@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
 */
public enum class TimeGrainType(
    public val javaValue: com.pulumi.azurenative.consumption.enums.TimeGrainType,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.enums.TimeGrainType> {
    Monthly(com.pulumi.azurenative.consumption.enums.TimeGrainType.Monthly),
    Quarterly(com.pulumi.azurenative.consumption.enums.TimeGrainType.Quarterly),
    Annually(com.pulumi.azurenative.consumption.enums.TimeGrainType.Annually),
    BillingMonth(com.pulumi.azurenative.consumption.enums.TimeGrainType.BillingMonth),
    BillingQuarter(com.pulumi.azurenative.consumption.enums.TimeGrainType.BillingQuarter),
    BillingAnnual(com.pulumi.azurenative.consumption.enums.TimeGrainType.BillingAnnual),
    ;

    override fun toJava(): com.pulumi.azurenative.consumption.enums.TimeGrainType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.enums.TimeGrainType):
            TimeGrainType = TimeGrainType.values().first { it.javaValue == javaType }
    }
}
