@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies if the IP is exposed to the public internet or private VNET.
 */
public enum class ContainerGroupIpAddressType(
    public val javaValue: com.pulumi.azurenative.containerinstance.enums.ContainerGroupIpAddressType,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.enums.ContainerGroupIpAddressType> {
    Public(com.pulumi.azurenative.containerinstance.enums.ContainerGroupIpAddressType.Public),
    Private(com.pulumi.azurenative.containerinstance.enums.ContainerGroupIpAddressType.Private),
    ;

    override fun toJava(): com.pulumi.azurenative.containerinstance.enums.ContainerGroupIpAddressType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.enums.ContainerGroupIpAddressType):
            ContainerGroupIpAddressType =
            ContainerGroupIpAddressType.values().first { it.javaValue == javaType }
    }
}
