@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.GpuResourceArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.GpuSku
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The GPU resource.
 * @property count The count of the GPU resource.
 * @property sku The SKU of the GPU resource.
 */
public data class GpuResourceArgs(
    public val count: Output<Int>,
    public val sku: Output<Either<String, GpuSku>>,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.GpuResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.GpuResourceArgs =
        com.pulumi.azurenative.containerinstance.inputs.GpuResourceArgs.builder()
            .count(count.applyValue({ args0 -> args0 }))
            .sku(
                sku.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GpuResourceArgs].
 */
@PulumiTagMarker
public class GpuResourceArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var sku: Output<Either<String, GpuSku>>? = null

    /**
     * @param value The count of the GPU resource.
     */
    @JvmName("dbqelefcsurjinvm")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The SKU of the GPU resource.
     */
    @JvmName("oidberofgcvrrdyl")
    public suspend fun sku(`value`: Output<Either<String, GpuSku>>) {
        this.sku = value
    }

    /**
     * @param value The count of the GPU resource.
     */
    @JvmName("eawwpmgxllblexkc")
    public suspend fun count(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The SKU of the GPU resource.
     */
    @JvmName("tmlyayemmpidkjay")
    public suspend fun sku(`value`: Either<String, GpuSku>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The SKU of the GPU resource.
     */
    @JvmName("vsurasshxodmvetn")
    public fun sku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GpuSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The SKU of the GPU resource.
     */
    @JvmName("ujutislkwcmuummm")
    public fun sku(`value`: GpuSku) {
        val toBeMapped = Either.ofRight<String, GpuSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    internal fun build(): GpuResourceArgs = GpuResourceArgs(
        count = count ?: throw PulumiNullFieldException("count"),
        sku = sku ?: throw PulumiNullFieldException("sku"),
    )
}
