@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.HttpHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The HTTP header.
 * @property name The header name.
 * @property value The header value.
 */
public data class HttpHeaderArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.HttpHeaderArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.HttpHeaderArgs =
        com.pulumi.azurenative.containerinstance.inputs.HttpHeaderArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpHeaderArgs].
 */
@PulumiTagMarker
public class HttpHeaderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The header name.
     */
    @JvmName("kyohqvkbnutofmnd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The header value.
     */
    @JvmName("fjwkjtpbpjgxutmw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The header name.
     */
    @JvmName("cijmwtohgartxssn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The header value.
     */
    @JvmName("mqojeevqirldkfok")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HttpHeaderArgs = HttpHeaderArgs(
        name = name,
        `value` = `value`,
    )
}
