@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.PortArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.ContainerGroupNetworkProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The port exposed on the container group.
 * @property port The port number.
 * @property protocol The protocol associated with the port.
 */
public data class PortArgs(
    public val port: Output<Int>,
    public val protocol: Output<Either<String, ContainerGroupNetworkProtocol>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.PortArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.PortArgs =
        com.pulumi.azurenative.containerinstance.inputs.PortArgs.builder()
            .port(port.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PortArgs].
 */
@PulumiTagMarker
public class PortArgsBuilder internal constructor() {
    private var port: Output<Int>? = null

    private var protocol: Output<Either<String, ContainerGroupNetworkProtocol>>? = null

    /**
     * @param value The port number.
     */
    @JvmName("uolyfndqgwlbaqiu")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("jljkeoyqfkrrauxb")
    public suspend fun protocol(`value`: Output<Either<String, ContainerGroupNetworkProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The port number.
     */
    @JvmName("hqfdfpsdkdvbkdxs")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("ciudkvuafhdcrsid")
    public suspend fun protocol(`value`: Either<String, ContainerGroupNetworkProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("lgvwfjpnuhtmqqay")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerGroupNetworkProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol associated with the port.
     */
    @JvmName("okcyfmrhuqgdbpxs")
    public fun protocol(`value`: ContainerGroupNetworkProtocol) {
        val toBeMapped = Either.ofRight<String, ContainerGroupNetworkProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): PortArgs = PortArgs(
        port = port ?: throw PulumiNullFieldException("port"),
        protocol = protocol,
    )
}
