@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The resource requests.
 * @property cpu The CPU request of this container instance.
 * @property gpu The GPU request of this container instance.
 * @property memoryInGB The memory request in GB of this container instance.
 */
public data class ResourceRequestsArgs(
    public val cpu: Output<Double>,
    public val gpu: Output<GpuResourceArgs>? = null,
    public val memoryInGB: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs =
        com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs.builder()
            .cpu(cpu.applyValue({ args0 -> args0 }))
            .gpu(gpu?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memoryInGB(memoryInGB.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceRequestsArgs].
 */
@PulumiTagMarker
public class ResourceRequestsArgsBuilder internal constructor() {
    private var cpu: Output<Double>? = null

    private var gpu: Output<GpuResourceArgs>? = null

    private var memoryInGB: Output<Double>? = null

    /**
     * @param value The CPU request of this container instance.
     */
    @JvmName("jxmyspyysjpbkjyu")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The GPU request of this container instance.
     */
    @JvmName("ikstwdtoclhpnfks")
    public suspend fun gpu(`value`: Output<GpuResourceArgs>) {
        this.gpu = value
    }

    /**
     * @param value The memory request in GB of this container instance.
     */
    @JvmName("ldobajtfypwvgmwy")
    public suspend fun memoryInGB(`value`: Output<Double>) {
        this.memoryInGB = value
    }

    /**
     * @param value The CPU request of this container instance.
     */
    @JvmName("nmblvctrbeysqohc")
    public suspend fun cpu(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The GPU request of this container instance.
     */
    @JvmName("qhiloejgtoxhrmwk")
    public suspend fun gpu(`value`: GpuResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param argument The GPU request of this container instance.
     */
    @JvmName("wdeufwgcvdanqcpa")
    public suspend fun gpu(argument: suspend GpuResourceArgsBuilder.() -> Unit) {
        val toBeMapped = GpuResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gpu = mapped
    }

    /**
     * @param value The memory request in GB of this container instance.
     */
    @JvmName("rtkgsvjbhqyxeokm")
    public suspend fun memoryInGB(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryInGB = mapped
    }

    internal fun build(): ResourceRequestsArgs = ResourceRequestsArgs(
        cpu = cpu ?: throw PulumiNullFieldException("cpu"),
        gpu = gpu,
        memoryInGB = memoryInGB ?: throw PulumiNullFieldException("memoryInGB"),
    )
}
