@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.SecurityContextCapabilitiesDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The capabilities to add or drop from a container.
 * @property add The capabilities to add to the container.
 * @property drop The capabilities to drop from the container.
 */
public data class SecurityContextCapabilitiesDefinitionArgs(
    public val add: Output<List<String>>? = null,
    public val drop: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.SecurityContextCapabilitiesDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerinstance.inputs.SecurityContextCapabilitiesDefinitionArgs =
        com.pulumi.azurenative.containerinstance.inputs.SecurityContextCapabilitiesDefinitionArgs.builder()
            .add(add?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .drop(drop?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SecurityContextCapabilitiesDefinitionArgs].
 */
@PulumiTagMarker
public class SecurityContextCapabilitiesDefinitionArgsBuilder internal constructor() {
    private var add: Output<List<String>>? = null

    private var drop: Output<List<String>>? = null

    /**
     * @param value The capabilities to add to the container.
     */
    @JvmName("ypwsetshqaqdyxow")
    public suspend fun add(`value`: Output<List<String>>) {
        this.add = value
    }

    @JvmName("dgjqhbnctdlbbvtv")
    public suspend fun add(vararg values: Output<String>) {
        this.add = Output.all(values.asList())
    }

    /**
     * @param values The capabilities to add to the container.
     */
    @JvmName("qskrrllupeckplro")
    public suspend fun add(values: List<Output<String>>) {
        this.add = Output.all(values)
    }

    /**
     * @param value The capabilities to drop from the container.
     */
    @JvmName("ucwkcerolrxkgpxj")
    public suspend fun drop(`value`: Output<List<String>>) {
        this.drop = value
    }

    @JvmName("bwyetrpsupyavgod")
    public suspend fun drop(vararg values: Output<String>) {
        this.drop = Output.all(values.asList())
    }

    /**
     * @param values The capabilities to drop from the container.
     */
    @JvmName("jsprxmidugerqype")
    public suspend fun drop(values: List<Output<String>>) {
        this.drop = Output.all(values)
    }

    /**
     * @param value The capabilities to add to the container.
     */
    @JvmName("dupqydtfyclrcqbl")
    public suspend fun add(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.add = mapped
    }

    /**
     * @param values The capabilities to add to the container.
     */
    @JvmName("tcoeiqgxhboroorf")
    public suspend fun add(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.add = mapped
    }

    /**
     * @param value The capabilities to drop from the container.
     */
    @JvmName("jlsqackfdrspotrv")
    public suspend fun drop(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drop = mapped
    }

    /**
     * @param values The capabilities to drop from the container.
     */
    @JvmName("cxgvtovmkpmykxlw")
    public suspend fun drop(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.drop = mapped
    }

    internal fun build(): SecurityContextCapabilitiesDefinitionArgs =
        SecurityContextCapabilitiesDefinitionArgs(
            add = add,
            drop = drop,
        )
}
