@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.SecurityContextDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The security context for the container.
 * @property allowPrivilegeEscalation A boolean value indicating whether the init process can elevate its privileges
 * @property capabilities The capabilities to add or drop from a container.
 * @property privileged The flag to determine if the container permissions is elevated to Privileged.
 * @property runAsGroup Sets the User GID for the container.
 * @property runAsUser Sets the User UID for the container.
 * @property seccompProfile a base64 encoded string containing the contents of the JSON in the seccomp profile
 */
public data class SecurityContextDefinitionArgs(
    public val allowPrivilegeEscalation: Output<Boolean>? = null,
    public val capabilities: Output<SecurityContextCapabilitiesDefinitionArgs>? = null,
    public val privileged: Output<Boolean>? = null,
    public val runAsGroup: Output<Int>? = null,
    public val runAsUser: Output<Int>? = null,
    public val seccompProfile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.SecurityContextDefinitionArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerinstance.inputs.SecurityContextDefinitionArgs =
        com.pulumi.azurenative.containerinstance.inputs.SecurityContextDefinitionArgs.builder()
            .allowPrivilegeEscalation(allowPrivilegeEscalation?.applyValue({ args0 -> args0 }))
            .capabilities(capabilities?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privileged(privileged?.applyValue({ args0 -> args0 }))
            .runAsGroup(runAsGroup?.applyValue({ args0 -> args0 }))
            .runAsUser(runAsUser?.applyValue({ args0 -> args0 }))
            .seccompProfile(seccompProfile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityContextDefinitionArgs].
 */
@PulumiTagMarker
public class SecurityContextDefinitionArgsBuilder internal constructor() {
    private var allowPrivilegeEscalation: Output<Boolean>? = null

    private var capabilities: Output<SecurityContextCapabilitiesDefinitionArgs>? = null

    private var privileged: Output<Boolean>? = null

    private var runAsGroup: Output<Int>? = null

    private var runAsUser: Output<Int>? = null

    private var seccompProfile: Output<String>? = null

    /**
     * @param value A boolean value indicating whether the init process can elevate its privileges
     */
    @JvmName("acfafeirkdgjsjcv")
    public suspend fun allowPrivilegeEscalation(`value`: Output<Boolean>) {
        this.allowPrivilegeEscalation = value
    }

    /**
     * @param value The capabilities to add or drop from a container.
     */
    @JvmName("cibvujpkywkkaybp")
    public suspend fun capabilities(`value`: Output<SecurityContextCapabilitiesDefinitionArgs>) {
        this.capabilities = value
    }

    /**
     * @param value The flag to determine if the container permissions is elevated to Privileged.
     */
    @JvmName("furkojqfgwtatrmj")
    public suspend fun privileged(`value`: Output<Boolean>) {
        this.privileged = value
    }

    /**
     * @param value Sets the User GID for the container.
     */
    @JvmName("yvawbmhpmtquwdwq")
    public suspend fun runAsGroup(`value`: Output<Int>) {
        this.runAsGroup = value
    }

    /**
     * @param value Sets the User UID for the container.
     */
    @JvmName("bvemnukoqnksvris")
    public suspend fun runAsUser(`value`: Output<Int>) {
        this.runAsUser = value
    }

    /**
     * @param value a base64 encoded string containing the contents of the JSON in the seccomp profile
     */
    @JvmName("karsnjeysmhxkejj")
    public suspend fun seccompProfile(`value`: Output<String>) {
        this.seccompProfile = value
    }

    /**
     * @param value A boolean value indicating whether the init process can elevate its privileges
     */
    @JvmName("edxgbqcmbppveyqf")
    public suspend fun allowPrivilegeEscalation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowPrivilegeEscalation = mapped
    }

    /**
     * @param value The capabilities to add or drop from a container.
     */
    @JvmName("pkytcjqnmmtygyrx")
    public suspend fun capabilities(`value`: SecurityContextCapabilitiesDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument The capabilities to add or drop from a container.
     */
    @JvmName("plhadwvcpuuueind")
    public suspend
    fun capabilities(argument: suspend SecurityContextCapabilitiesDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityContextCapabilitiesDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param value The flag to determine if the container permissions is elevated to Privileged.
     */
    @JvmName("cbcacjliqjrwmfly")
    public suspend fun privileged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privileged = mapped
    }

    /**
     * @param value Sets the User GID for the container.
     */
    @JvmName("qhjbirdgtempvcsj")
    public suspend fun runAsGroup(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsGroup = mapped
    }

    /**
     * @param value Sets the User UID for the container.
     */
    @JvmName("dhoxtapqjckbycfo")
    public suspend fun runAsUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsUser = mapped
    }

    /**
     * @param value a base64 encoded string containing the contents of the JSON in the seccomp profile
     */
    @JvmName("hrkwcaxkpjuhkgwy")
    public suspend fun seccompProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.seccompProfile = mapped
    }

    internal fun build(): SecurityContextDefinitionArgs = SecurityContextDefinitionArgs(
        allowPrivilegeEscalation = allowPrivilegeEscalation,
        capabilities = capabilities,
        privileged = privileged,
        runAsGroup = runAsGroup,
        runAsUser = runAsUser,
        seccompProfile = seccompProfile,
    )
}
