@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Container group subnet information.
 * @property id Resource ID of virtual network and subnet.
 * @property name Friendly name for the subnet.
 */
public data class ContainerGroupSubnetIdResponse(
    public val id: String,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerGroupSubnetIdResponse):
            ContainerGroupSubnetIdResponse = ContainerGroupSubnetIdResponse(
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
