@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The container probe, for liveness or readiness
 * @property exec The execution command to probe
 * @property failureThreshold The failure threshold.
 * @property httpGet The Http Get settings to probe
 * @property initialDelaySeconds The initial delay seconds.
 * @property periodSeconds The period seconds.
 * @property successThreshold The success threshold.
 * @property timeoutSeconds The timeout seconds.
 */
public data class ContainerProbeResponse(
    public val exec: ContainerExecResponse? = null,
    public val failureThreshold: Int? = null,
    public val httpGet: ContainerHttpGetResponse? = null,
    public val initialDelaySeconds: Int? = null,
    public val periodSeconds: Int? = null,
    public val successThreshold: Int? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerProbeResponse):
            ContainerProbeResponse = ContainerProbeResponse(
            exec = javaType.exec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerExecResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failureThreshold = javaType.failureThreshold().map({ args0 -> args0 }).orElse(null),
            httpGet = javaType.httpGet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerHttpGetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialDelaySeconds = javaType.initialDelaySeconds().map({ args0 -> args0 }).orElse(null),
            periodSeconds = javaType.periodSeconds().map({ args0 -> args0 }).orElse(null),
            successThreshold = javaType.successThreshold().map({ args0 -> args0 }).orElse(null),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
