@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The environment variable to set within the container instance.
 * @property name The name of the environment variable.
 * @property secureValue The value of the secure environment variable.
 * @property value The value of the environment variable.
 */
public data class EnvironmentVariableResponse(
    public val name: String,
    public val secureValue: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.EnvironmentVariableResponse):
            EnvironmentVariableResponse = EnvironmentVariableResponse(
            name = javaType.name(),
            secureValue = javaType.secureValue().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
