@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The init container definition.
 * @property command The command to execute within the init container in exec form.
 * @property environmentVariables The environment variables to set in the init container.
 * @property image The image of the init container.
 * @property instanceView The instance view of the init container. Only valid in response.
 * @property name The name for the init container.
 * @property securityContext The container security properties.
 * @property volumeMounts The volume mounts available to the init container.
 */
public data class InitContainerDefinitionResponse(
    public val command: List<String>? = null,
    public val environmentVariables: List<EnvironmentVariableResponse>? = null,
    public val image: String? = null,
    public val instanceView: InitContainerPropertiesDefinitionResponseInstanceView,
    public val name: String,
    public val securityContext: SecurityContextDefinitionResponse? = null,
    public val volumeMounts: List<VolumeMountResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.InitContainerDefinitionResponse):
            InitContainerDefinitionResponse = InitContainerDefinitionResponse(
            command = javaType.command().map({ args0 -> args0 }),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin(args0)
                })
            }),
            image = javaType.image().map({ args0 -> args0 }).orElse(null),
            instanceView = javaType.instanceView().let({ args0 ->
                com.pulumi.azurenative.containerinstance.kotlin.outputs.InitContainerPropertiesDefinitionResponseInstanceView.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            securityContext = javaType.securityContext().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.SecurityContextDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            volumeMounts = javaType.volumeMounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.VolumeMountResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
