@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The security context for the container.
 * @property allowPrivilegeEscalation A boolean value indicating whether the init process can elevate its privileges
 * @property capabilities The capabilities to add or drop from a container.
 * @property privileged The flag to determine if the container permissions is elevated to Privileged.
 * @property runAsGroup Sets the User GID for the container.
 * @property runAsUser Sets the User UID for the container.
 * @property seccompProfile a base64 encoded string containing the contents of the JSON in the seccomp profile
 */
public data class SecurityContextDefinitionResponse(
    public val allowPrivilegeEscalation: Boolean? = null,
    public val capabilities: SecurityContextCapabilitiesDefinitionResponse? = null,
    public val privileged: Boolean? = null,
    public val runAsGroup: Int? = null,
    public val runAsUser: Int? = null,
    public val seccompProfile: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.SecurityContextDefinitionResponse):
            SecurityContextDefinitionResponse = SecurityContextDefinitionResponse(
            allowPrivilegeEscalation = javaType.allowPrivilegeEscalation().map({ args0 -> args0 }).orElse(null),
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.SecurityContextCapabilitiesDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privileged = javaType.privileged().map({ args0 -> args0 }).orElse(null),
            runAsGroup = javaType.runAsGroup().map({ args0 -> args0 }).orElse(null),
            runAsUser = javaType.runAsUser().map({ args0 -> args0 }).orElse(null),
            seccompProfile = javaType.seccompProfile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
