@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The list of user identities associated with the container group. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 * @property clientId The client id of user assigned identity.
 * @property principalId The principal id of user assigned identity.
 */
public data class UserAssignedIdentitiesResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.UserAssignedIdentitiesResponse):
            UserAssignedIdentitiesResponse = UserAssignedIdentitiesResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
