@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.AgentPoolArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.OS
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The agentpool that has the ARM resource and properties.
 * The agentpool will have all information to create an agent pool.
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### AgentPools_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerRegistry.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "myAgentPool",
 *         Count = 1,
 *         Location = "WESTUS",
 *         Os = "Linux",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         Tier = "S1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewAgentPool(ctx, "agentPool", &containerregistry.AgentPoolArgs{
 * 			AgentPoolName:     pulumi.String("myAgentPool"),
 * 			Count:             pulumi.Int(1),
 * 			Location:          pulumi.String("WESTUS"),
 * 			Os:                pulumi.String("Linux"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			Tier: pulumi.String("S1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.AgentPool;
 * import com.pulumi.azurenative.containerregistry.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("myAgentPool")
 *             .count(1)
 *             .location("WESTUS")
 *             .os("Linux")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key", "value"))
 *             .tier("S1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:AgentPool myAgentPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/agentPools/{agentPoolName}
 * ```
 * @property agentPoolName The name of the agent pool.
 * @property count The count of agent machine
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property os The OS of agent machine
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property tags The tags of the resource.
 * @property tier The Tier of agent machine
 * @property virtualNetworkSubnetResourceId The Virtual Network Subnet Resource Id of the agent machine
 */
public data class AgentPoolArgs(
    public val agentPoolName: Output<String>? = null,
    public val count: Output<Int>? = null,
    public val location: Output<String>? = null,
    public val os: Output<Either<String, OS>>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tier: Output<String>? = null,
    public val virtualNetworkSubnetResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.AgentPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.AgentPoolArgs =
        com.pulumi.azurenative.containerregistry.AgentPoolArgs.builder()
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .count(count?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .os(
                os?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tier(tier?.applyValue({ args0 -> args0 }))
            .virtualNetworkSubnetResourceId(
                virtualNetworkSubnetResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [AgentPoolArgs].
 */
@PulumiTagMarker
public class AgentPoolArgsBuilder internal constructor() {
    private var agentPoolName: Output<String>? = null

    private var count: Output<Int>? = null

    private var location: Output<String>? = null

    private var os: Output<Either<String, OS>>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tier: Output<String>? = null

    private var virtualNetworkSubnetResourceId: Output<String>? = null

    /**
     * @param value The name of the agent pool.
     */
    @JvmName("axwgojhaiwhcgdpq")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The count of agent machine
     */
    @JvmName("khoagrmidksqyteo")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("ghdmixrntstaxjbm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The OS of agent machine
     */
    @JvmName("ncrklhmifolgwsde")
    public suspend fun os(`value`: Output<Either<String, OS>>) {
        this.os = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("bwbksevvinyatvwo")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("fdfgfarovckbebqj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("mwsgjleoeupnshlm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Tier of agent machine
     */
    @JvmName("bfrgymfomrhjckqm")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The Virtual Network Subnet Resource Id of the agent machine
     */
    @JvmName("bbdrvotutdnskdiq")
    public suspend fun virtualNetworkSubnetResourceId(`value`: Output<String>) {
        this.virtualNetworkSubnetResourceId = value
    }

    /**
     * @param value The name of the agent pool.
     */
    @JvmName("unkxgetcywksekxy")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The count of agent machine
     */
    @JvmName("hrejmkyilwdfqdcw")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("elojfftsrisyvcpa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The OS of agent machine
     */
    @JvmName("oikqbfdegdpctobu")
    public suspend fun os(`value`: Either<String, OS>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value The OS of agent machine
     */
    @JvmName("btawcijmksljrmia")
    public fun os(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OS>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value The OS of agent machine
     */
    @JvmName("swvkxjomaphithno")
    public fun os(`value`: OS) {
        val toBeMapped = Either.ofRight<String, OS>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("hvgsryluwqtaojyk")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("fbuprwkhmwylclbc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ywnjjxuqjxjdoavm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("rddspamkqyleucvk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Tier of agent machine
     */
    @JvmName("nqirfbqpfrooienu")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The Virtual Network Subnet Resource Id of the agent machine
     */
    @JvmName("emhjkbokofhqawtj")
    public suspend fun virtualNetworkSubnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkSubnetResourceId = mapped
    }

    internal fun build(): AgentPoolArgs = AgentPoolArgs(
        agentPoolName = agentPoolName,
        count = count,
        location = location,
        os = os,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        tier = tier,
        virtualNetworkSubnetResourceId = virtualNetworkSubnetResourceId,
    )
}
