@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ArchiveVersion].
 */
@PulumiTagMarker
public class ArchiveVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArchiveVersionArgs = ArchiveVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArchiveVersionArgsBuilder.() -> Unit) {
        val builder = ArchiveVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ArchiveVersion {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.ArchiveVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ArchiveVersion(builtJavaResource)
    }
}

/**
 * An object that represents an export pipeline for a container registry.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ArchiveVersionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var archiveVersion = new AzureNative.ContainerRegistry.ArchiveVersion("archiveVersion", new()
 *     {
 *         ArchiveName = "myArchiveName",
 *         ArchiveVersionName = "myArchiveVersionName",
 *         PackageType = "rpm",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewArchiveVersion(ctx, "archiveVersion", &containerregistry.ArchiveVersionArgs{
 * 			ArchiveName:        pulumi.String("myArchiveName"),
 * 			ArchiveVersionName: pulumi.String("myArchiveVersionName"),
 * 			PackageType:        pulumi.String("rpm"),
 * 			RegistryName:       pulumi.String("myRegistry"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ArchiveVersion;
 * import com.pulumi.azurenative.containerregistry.ArchiveVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var archiveVersion = new ArchiveVersion("archiveVersion", ArchiveVersionArgs.builder()
 *             .archiveName("myArchiveName")
 *             .archiveVersionName("myArchiveVersionName")
 *             .packageType("rpm")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ArchiveVersion myArchiveVersionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/packages/{packageType}/archives/{archiveName}/versions/{archiveVersionName}
 * ```
 */
public class ArchiveVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.ArchiveVersion,
) : KotlinCustomResource(javaResource, ArchiveVersionMapper) {
    /**
     * The detailed error message for the archive version in the case of failure.
     */
    public val archiveVersionErrorMessage: Output<String>?
        get() = javaResource.archiveVersionErrorMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the archive at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ArchiveVersionMapper : ResourceMapper<ArchiveVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.ArchiveVersion::class == javaResource::class

    override fun map(javaResource: Resource): ArchiveVersion = ArchiveVersion(
        javaResource as
            com.pulumi.azurenative.containerregistry.ArchiveVersion,
    )
}

/**
 * @see [ArchiveVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArchiveVersion].
 */
public suspend fun archiveVersion(
    name: String,
    block: suspend ArchiveVersionResourceBuilder.() -> Unit,
): ArchiveVersion {
    val builder = ArchiveVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArchiveVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun archiveVersion(name: String): ArchiveVersion {
    val builder = ArchiveVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
