@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.ScopeMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An object that represents a scope map for a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ScopeMapCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeMap = new AzureNative.ContainerRegistry.ScopeMap("scopeMap", new()
 *     {
 *         Actions = new[]
 *         {
 *             "repositories/myrepository/contentWrite",
 *             "repositories/myrepository/delete",
 *         },
 *         Description = "Developer Scopes",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         ScopeMapName = "myScopeMap",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewScopeMap(ctx, "scopeMap", &containerregistry.ScopeMapArgs{
 * 			Actions: pulumi.StringArray{
 * 				pulumi.String("repositories/myrepository/contentWrite"),
 * 				pulumi.String("repositories/myrepository/delete"),
 * 			},
 * 			Description:       pulumi.String("Developer Scopes"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScopeMapName:      pulumi.String("myScopeMap"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ScopeMap;
 * import com.pulumi.azurenative.containerregistry.ScopeMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeMap = new ScopeMap("scopeMap", ScopeMapArgs.builder()
 *             .actions(
 *                 "repositories/myrepository/contentWrite",
 *                 "repositories/myrepository/delete")
 *             .description("Developer Scopes")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .scopeMapName("myScopeMap")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ScopeMap myScopeMap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scopeMaps/{scopeMapName}
 * ```
 * @property actions The list of scoped permissions for registry artifacts.
 * E.g. repositories/repository-name/content/read,
 * repositories/repository-name/metadata/write
 * @property description The user friendly description of the scope map.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scopeMapName The name of the scope map.
 */
public data class ScopeMapArgs(
    public val actions: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scopeMapName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.ScopeMapArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.ScopeMapArgs =
        com.pulumi.azurenative.containerregistry.ScopeMapArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scopeMapName(scopeMapName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopeMapArgs].
 */
@PulumiTagMarker
public class ScopeMapArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scopeMapName: Output<String>? = null

    /**
     * @param value The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write
     */
    @JvmName("pvklmjwqokshahry")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("dbxmviagyighqqnj")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write
     */
    @JvmName("jgafkobmqmdcjngk")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value The user friendly description of the scope map.
     */
    @JvmName("jdpirfsqfldjnnut")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("ixouvarrirfwnrna")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wmyrmnwljajkwwsu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the scope map.
     */
    @JvmName("yyqxhjqduhtokmom")
    public suspend fun scopeMapName(`value`: Output<String>) {
        this.scopeMapName = value
    }

    /**
     * @param value The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write
     */
    @JvmName("caquapfkgthmajch")
    public suspend fun actions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write
     */
    @JvmName("lciwojdydbkrjofw")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value The user friendly description of the scope map.
     */
    @JvmName("pukxcurnwnofmqea")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("dgvjpigevuhblqis")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wdoclrskamsakbkj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the scope map.
     */
    @JvmName("mtsgjyrvajciqqlh")
    public suspend fun scopeMapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeMapName = mapped
    }

    internal fun build(): ScopeMapArgs = ScopeMapArgs(
        actions = actions,
        description = description,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        scopeMapName = scopeMapName,
    )
}
