@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.AgentPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.CredentialsResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PlatformPropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.TriggerPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.containerregistry.kotlin.outputs.AgentPropertiesResponse.Companion.toKotlin as agentPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.CredentialsResponse.Companion.toKotlin as credentialsResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin as identityPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.PlatformPropertiesResponse.Companion.toKotlin as platformPropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.TriggerPropertiesResponse.Companion.toKotlin as triggerPropertiesResponseToKotlin

/**
 * Builder for [Task].
 */
@PulumiTagMarker
public class TaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TaskArgs = TaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TaskArgsBuilder.() -> Unit) {
        val builder = TaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Task {
        val builtJavaResource = com.pulumi.azurenative.containerregistry.Task(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Task(builtJavaResource)
    }
}

/**
 * The task that has the ARM resource and task properties.
 * The task will have all information to schedule a run against it.
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * Other available API versions: 2018-09-01, 2019-04-01.
 * ## Example Usage
 * ### Tasks_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned,
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         LogTemplate = "acr/tasks:{{.Run.OS}}",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *                 UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
 *                 UpdateTriggerPayloadType = "Token",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: &containerregistry.IdentityPropertiesArgs{
 * Type: containerregistry.ResourceIdentityTypeSystemAssigned,
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * LogTemplate: pulumi.String("acr/tasks:{{.Run.OS}}"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * UpdateTriggerEndpoint: pulumi.String("https://user:pass@mycicd.webhook.com?token=foo"),
 * UpdateTriggerPayloadType: pulumi.String("Token"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .logTemplate("acr/tasks:{{.Run.OS}}")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger"),
 *                     Map.entry("updateTriggerEndpoint", "https://user:pass@mycicd.webhook.com?token=foo"),
 *                     Map.entry("updateTriggerPayloadType", "Token")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_QuickTask
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         IsSystemTask = true,
 *         Location = "eastus",
 *         LogTemplate = "acr/tasks:{{.Run.OS}}",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "quicktask",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * 			IsSystemTask:      pulumi.Bool(true),
 * 			Location:          pulumi.String("eastus"),
 * 			LogTemplate:       pulumi.String("acr/tasks:{{.Run.OS}}"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Status:            pulumi.String("Enabled"),
 * 			Tags: pulumi.StringMap{
 * 				"testkey": pulumi.String("value"),
 * 			},
 * 			TaskName: pulumi.String("quicktask"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .isSystemTask(true)
 *             .location("eastus")
 *             .logTemplate("acr/tasks:{{.Run.OS}}")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("quicktask")
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_WithSystemAndUserIdentities
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned_UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", null },
 *             },
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *                 UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
 *                 UpdateTriggerPayloadType = "Default",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: containerregistry.IdentityPropertiesResponse{
 * Type: containerregistry.ResourceIdentityType_SystemAssigned_UserAssigned,
 * UserAssignedIdentities: containerregistry.UserIdentityPropertiesMap{
 * "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2": nil,
 * },
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * UpdateTriggerEndpoint: pulumi.String("https://user:pass@mycicd.webhook.com?token=foo"),
 * UpdateTriggerPayloadType: pulumi.String("Default"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "SystemAssigned, UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.of("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", ))
 *             ))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger"),
 *                     Map.entry("updateTriggerEndpoint", "https://user:pass@mycicd.webhook.com?token=foo"),
 *                     Map.entry("updateTriggerPayloadType", "Default")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_WithUserIdentities
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.UserAssigned,
 *             UserAssignedIdentities =
 *             {
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1", null },
 *                 { "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", null },
 *             },
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *                 UpdateTriggerEndpoint = "https://user:pass@mycicd.webhook.com?token=foo",
 *                 UpdateTriggerPayloadType = "Default",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: containerregistry.IdentityPropertiesResponse{
 * Type: containerregistry.ResourceIdentityTypeUserAssigned,
 * UserAssignedIdentities: containerregistry.UserIdentityPropertiesMap{
 * "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1": nil,
 * "/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2": nil,
 * },
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * UpdateTriggerEndpoint: pulumi.String("https://user:pass@mycicd.webhook.com?token=foo"),
 * UpdateTriggerPayloadType: pulumi.String("Default"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.ofEntries(
 *                 Map.entry("type", "UserAssigned"),
 *                 Map.entry("userAssignedIdentities", Map.ofEntries(
 *                     Map.entry("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity1", ),
 *                     Map.entry("/subscriptions/f9d7ebed-adbd-4cb4-b973-aaf82c136138/resourcegroups/myResourceGroup1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identity2", )
 *                 ))
 *             ))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger"),
 *                     Map.entry("updateTriggerEndpoint", "https://user:pass@mycicd.webhook.com?token=foo"),
 *                     Map.entry("updateTriggerPayloadType", "Default")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Tasks_Create_WithUserIdentities_WithSystemIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new AzureNative.ContainerRegistry.Task("task", new()
 *     {
 *         AgentConfiguration = new AzureNative.ContainerRegistry.Inputs.AgentPropertiesArgs
 *         {
 *             Cpu = 2,
 *         },
 *         Identity = new AzureNative.ContainerRegistry.Inputs.IdentityPropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.ResourceIdentityType.SystemAssigned,
 *         },
 *         IsSystemTask = false,
 *         Location = "eastus",
 *         Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *         {
 *             Architecture = "amd64",
 *             Os = "Linux",
 *         },
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Status = "Enabled",
 *         Step = new AzureNative.ContainerRegistry.Inputs.DockerBuildStepArgs
 *         {
 *             Arguments = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = false,
 *                     Name = "mytestargument",
 *                     Value = "mytestvalue",
 *                 },
 *                 new AzureNative.ContainerRegistry.Inputs.ArgumentArgs
 *                 {
 *                     IsSecret = true,
 *                     Name = "mysecrettestargument",
 *                     Value = "mysecrettestvalue",
 *                 },
 *             },
 *             ContextPath = "src",
 *             DockerFilePath = "src/DockerFile",
 *             ImageNames = new[]
 *             {
 *                 "azurerest:testtag",
 *             },
 *             IsPushEnabled = true,
 *             NoCache = false,
 *             Type = "Docker",
 *         },
 *         Tags =
 *         {
 *             { "testkey", "value" },
 *         },
 *         TaskName = "mytTask",
 *         Trigger = new AzureNative.ContainerRegistry.Inputs.TriggerPropertiesArgs
 *         {
 *             BaseImageTrigger = new AzureNative.ContainerRegistry.Inputs.BaseImageTriggerArgs
 *             {
 *                 BaseImageTriggerType = "Runtime",
 *                 Name = "myBaseImageTrigger",
 *             },
 *             SourceTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.SourceTriggerArgs
 *                 {
 *                     Name = "mySourceTrigger",
 *                     SourceRepository = new AzureNative.ContainerRegistry.Inputs.SourcePropertiesArgs
 *                     {
 *                         Branch = "master",
 *                         RepositoryUrl = "https://github.com/Azure/azure-rest-api-specs",
 *                         SourceControlAuthProperties = new AzureNative.ContainerRegistry.Inputs.AuthInfoArgs
 *                         {
 *                             Token = "xxxxx",
 *                             TokenType = "PAT",
 *                         },
 *                         SourceControlType = "Github",
 *                     },
 *                     SourceTriggerEvents = new[]
 *                     {
 *                         "commit",
 *                     },
 *                 },
 *             },
 *             TimerTriggers = new[]
 *             {
 *                 new AzureNative.ContainerRegistry.Inputs.TimerTriggerArgs
 *                 {
 *                     Name = "myTimerTrigger",
 *                     Schedule = "30 9 * * 1-5",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerregistry.NewTask(ctx, "task", &containerregistry.TaskArgs{
 * AgentConfiguration: &containerregistry.AgentPropertiesArgs{
 * Cpu: pulumi.Int(2),
 * },
 * Identity: &containerregistry.IdentityPropertiesArgs{
 * Type: containerregistry.ResourceIdentityTypeSystemAssigned,
 * },
 * IsSystemTask: pulumi.Bool(false),
 * Location: pulumi.String("eastus"),
 * Platform: &containerregistry.PlatformPropertiesArgs{
 * Architecture: pulumi.String("amd64"),
 * Os: pulumi.String("Linux"),
 * },
 * RegistryName: pulumi.String("myRegistry"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Status: pulumi.String("Enabled"),
 * Step: containerregistry.DockerBuildStep{
 * Arguments: []containerregistry.Argument{
 * {
 * IsSecret: false,
 * Name: "mytestargument",
 * Value: "mytestvalue",
 * },
 * {
 * IsSecret: true,
 * Name: "mysecrettestargument",
 * Value: "mysecrettestvalue",
 * },
 * },
 * ContextPath: "src",
 * DockerFilePath: "src/DockerFile",
 * ImageNames: []string{
 * "azurerest:testtag",
 * },
 * IsPushEnabled: true,
 * NoCache: false,
 * Type: "Docker",
 * },
 * Tags: pulumi.StringMap{
 * "testkey": pulumi.String("value"),
 * },
 * TaskName: pulumi.String("mytTask"),
 * Trigger: containerregistry.TriggerPropertiesResponse{
 * BaseImageTrigger: &containerregistry.BaseImageTriggerArgs{
 * BaseImageTriggerType: pulumi.String("Runtime"),
 * Name: pulumi.String("myBaseImageTrigger"),
 * },
 * SourceTriggers: containerregistry.SourceTriggerArray{
 * interface{}{
 * Name: pulumi.String("mySourceTrigger"),
 * SourceRepository: interface{}{
 * Branch: pulumi.String("master"),
 * RepositoryUrl: pulumi.String("https://github.com/Azure/azure-rest-api-specs"),
 * SourceControlAuthProperties: &containerregistry.AuthInfoArgs{
 * Token: pulumi.String("xxxxx"),
 * TokenType: pulumi.String("PAT"),
 * },
 * SourceControlType: pulumi.String("Github"),
 * },
 * SourceTriggerEvents: pulumi.StringArray{
 * pulumi.String("commit"),
 * },
 * },
 * },
 * TimerTriggers: containerregistry.TimerTriggerArray{
 * &containerregistry.TimerTriggerArgs{
 * Name: pulumi.String("myTimerTrigger"),
 * Schedule: pulumi.String("30 9 * * 1-5"),
 * },
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Task;
 * import com.pulumi.azurenative.containerregistry.TaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new Task("task", TaskArgs.builder()
 *             .agentConfiguration(Map.of("cpu", 2))
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .isSystemTask(false)
 *             .location("eastus")
 *             .platform(Map.ofEntries(
 *                 Map.entry("architecture", "amd64"),
 *                 Map.entry("os", "Linux")
 *             ))
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .status("Enabled")
 *             .step(Map.ofEntries(
 *                 Map.entry("arguments",
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", false),
 *                         Map.entry("name", "mytestargument"),
 *                         Map.entry("value", "mytestvalue")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("isSecret", true),
 *                         Map.entry("name", "mysecrettestargument"),
 *                         Map.entry("value", "mysecrettestvalue")
 *                     )),
 *                 Map.entry("contextPath", "src"),
 *                 Map.entry("dockerFilePath", "src/DockerFile"),
 *                 Map.entry("imageNames", "azurerest:testtag"),
 *                 Map.entry("isPushEnabled", true),
 *                 Map.entry("noCache", false),
 *                 Map.entry("type", "Docker")
 *             ))
 *             .tags(Map.of("testkey", "value"))
 *             .taskName("mytTask")
 *             .trigger(Map.ofEntries(
 *                 Map.entry("baseImageTrigger", Map.ofEntries(
 *                     Map.entry("baseImageTriggerType", "Runtime"),
 *                     Map.entry("name", "myBaseImageTrigger")
 *                 )),
 *                 Map.entry("sourceTriggers", Map.ofEntries(
 *                     Map.entry("name", "mySourceTrigger"),
 *                     Map.entry("sourceRepository", Map.ofEntries(
 *                         Map.entry("branch", "master"),
 *                         Map.entry("repositoryUrl", "https://github.com/Azure/azure-rest-api-specs"),
 *                         Map.entry("sourceControlAuthProperties", Map.ofEntries(
 *                             Map.entry("token", "xxxxx"),
 *                             Map.entry("tokenType", "PAT")
 *                         )),
 *                         Map.entry("sourceControlType", "Github")
 *                     )),
 *                     Map.entry("sourceTriggerEvents", "commit")
 *                 )),
 *                 Map.entry("timerTriggers", Map.ofEntries(
 *                     Map.entry("name", "myTimerTrigger"),
 *                     Map.entry("schedule", "30 9 * * 1-5")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Task myTask /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}
 * ```
 */
public class Task internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.Task,
) : KotlinCustomResource(javaResource, TaskMapper) {
    /**
     * The machine configuration of the run agent.
     */
    public val agentConfiguration: Output<AgentPropertiesResponse>?
        get() = javaResource.agentConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The dedicated agent pool for the task.
     */
    public val agentPoolName: Output<String>?
        get() = javaResource.agentPoolName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The creation date of task.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The properties that describes a set of credentials that will be used when this run is invoked.
     */
    public val credentials: Output<CredentialsResponse>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    credentialsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityPropertiesResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The value of this property indicates whether the task resource is system task or not.
     */
    public val isSystemTask: Output<Boolean>?
        get() = javaResource.isSystemTask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The location of the resource. This cannot be changed after the resource is created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The template that describes the repository and tag information for run log artifact.
     */
    public val logTemplate: Output<String>?
        get() = javaResource.logTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The platform properties against which the run has to happen.
     */
    public val platform: Output<PlatformPropertiesResponse>?
        get() = javaResource.platform().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    platformPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the task.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The current status of task.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The properties of a task step.
     */
    public val step: Output<Any>?
        get() = javaResource.step().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Run timeout in seconds.
     */
    public val timeout: Output<Int>?
        get() = javaResource.timeout().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The properties that describe all triggers for the task.
     */
    public val trigger: Output<TriggerPropertiesResponse>?
        get() = javaResource.trigger().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    triggerPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TaskMapper : ResourceMapper<Task> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.Task::class == javaResource::class

    override fun map(javaResource: Resource): Task = Task(
        javaResource as
            com.pulumi.azurenative.containerregistry.Task,
    )
}

/**
 * @see [Task].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Task].
 */
public suspend fun task(name: String, block: suspend TaskResourceBuilder.() -> Unit): Task {
    val builder = TaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Task].
 * @param name The _unique_ name of the resulting resource.
 */
public fun task(name: String): Task {
    val builder = TaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
