@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.AgentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties that determine the run agent configuration.
 * @property cpu The CPU configuration in terms of number of cores required for the run.
 */
public data class AgentPropertiesArgs(
    public val cpu: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.AgentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.AgentPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.AgentPropertiesArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgentPropertiesArgs].
 */
@PulumiTagMarker
public class AgentPropertiesArgsBuilder internal constructor() {
    private var cpu: Output<Int>? = null

    /**
     * @param value The CPU configuration in terms of number of cores required for the run.
     */
    @JvmName("btbybcpulcsgcvaw")
    public suspend fun cpu(`value`: Output<Int>) {
        this.cpu = value
    }

    /**
     * @param value The CPU configuration in terms of number of cores required for the run.
     */
    @JvmName("ncrnlehlllujinqm")
    public suspend fun cpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    internal fun build(): AgentPropertiesArgs = AgentPropertiesArgs(
        cpu = cpu,
    )
}
