@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.BaseImageTriggerArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.BaseImageTriggerType
import com.pulumi.azurenative.containerregistry.kotlin.enums.TriggerStatus
import com.pulumi.azurenative.containerregistry.kotlin.enums.UpdateTriggerPayloadType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The trigger based on base image dependency.
 * @property baseImageTriggerType The type of the auto trigger for base image dependency updates.
 * @property name The name of the trigger.
 * @property status The current status of trigger.
 * @property updateTriggerEndpoint The endpoint URL for receiving update triggers.
 * @property updateTriggerPayloadType Type of Payload body for Base image update triggers.
 */
public data class BaseImageTriggerArgs(
    public val baseImageTriggerType: Output<Either<String, BaseImageTriggerType>>,
    public val name: Output<String>,
    public val status: Output<Either<String, TriggerStatus>>? = null,
    public val updateTriggerEndpoint: Output<String>? = null,
    public val updateTriggerPayloadType: Output<Either<String, UpdateTriggerPayloadType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.BaseImageTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.BaseImageTriggerArgs =
        com.pulumi.azurenative.containerregistry.inputs.BaseImageTriggerArgs.builder()
            .baseImageTriggerType(
                baseImageTriggerType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .updateTriggerEndpoint(updateTriggerEndpoint?.applyValue({ args0 -> args0 }))
            .updateTriggerPayloadType(
                updateTriggerPayloadType?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [BaseImageTriggerArgs].
 */
@PulumiTagMarker
public class BaseImageTriggerArgsBuilder internal constructor() {
    private var baseImageTriggerType: Output<Either<String, BaseImageTriggerType>>? = null

    private var name: Output<String>? = null

    private var status: Output<Either<String, TriggerStatus>>? = null

    private var updateTriggerEndpoint: Output<String>? = null

    private var updateTriggerPayloadType: Output<Either<String, UpdateTriggerPayloadType>>? = null

    /**
     * @param value The type of the auto trigger for base image dependency updates.
     */
    @JvmName("fcdvhunodhdinoeb")
    public suspend fun baseImageTriggerType(`value`: Output<Either<String, BaseImageTriggerType>>) {
        this.baseImageTriggerType = value
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("kwlxdbycaeleqjwb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("smggpoarlagvfmak")
    public suspend fun status(`value`: Output<Either<String, TriggerStatus>>) {
        this.status = value
    }

    /**
     * @param value The endpoint URL for receiving update triggers.
     */
    @JvmName("linehvpdtrngwwdv")
    public suspend fun updateTriggerEndpoint(`value`: Output<String>) {
        this.updateTriggerEndpoint = value
    }

    /**
     * @param value Type of Payload body for Base image update triggers.
     */
    @JvmName("oodwfldukupregkg")
    public suspend
    fun updateTriggerPayloadType(`value`: Output<Either<String, UpdateTriggerPayloadType>>) {
        this.updateTriggerPayloadType = value
    }

    /**
     * @param value The type of the auto trigger for base image dependency updates.
     */
    @JvmName("sqofhndmuntqfaii")
    public suspend fun baseImageTriggerType(`value`: Either<String, BaseImageTriggerType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseImageTriggerType = mapped
    }

    /**
     * @param value The type of the auto trigger for base image dependency updates.
     */
    @JvmName("iakuclfevipqtuiq")
    public fun baseImageTriggerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BaseImageTriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseImageTriggerType = mapped
    }

    /**
     * @param value The type of the auto trigger for base image dependency updates.
     */
    @JvmName("yyrqbfisaemrygar")
    public fun baseImageTriggerType(`value`: BaseImageTriggerType) {
        val toBeMapped = Either.ofRight<String, BaseImageTriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseImageTriggerType = mapped
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("mnxkaljhcvqjdnhj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("eutagepxwosxdrsd")
    public suspend fun status(`value`: Either<String, TriggerStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("eqobvlwhjftyypth")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("advnorsrtxukwdmv")
    public fun status(`value`: TriggerStatus) {
        val toBeMapped = Either.ofRight<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The endpoint URL for receiving update triggers.
     */
    @JvmName("maxdmacljwxibqew")
    public suspend fun updateTriggerEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateTriggerEndpoint = mapped
    }

    /**
     * @param value Type of Payload body for Base image update triggers.
     */
    @JvmName("uwmewduycltvujtj")
    public suspend fun updateTriggerPayloadType(`value`: Either<String, UpdateTriggerPayloadType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateTriggerPayloadType = mapped
    }

    /**
     * @param value Type of Payload body for Base image update triggers.
     */
    @JvmName("gyoeffsawdvlfcwe")
    public fun updateTriggerPayloadType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UpdateTriggerPayloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updateTriggerPayloadType = mapped
    }

    /**
     * @param value Type of Payload body for Base image update triggers.
     */
    @JvmName("xmaikclwgrwpycva")
    public fun updateTriggerPayloadType(`value`: UpdateTriggerPayloadType) {
        val toBeMapped = Either.ofRight<String, UpdateTriggerPayloadType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.updateTriggerPayloadType = mapped
    }

    internal fun build(): BaseImageTriggerArgs = BaseImageTriggerArgs(
        baseImageTriggerType = baseImageTriggerType ?: throw
            PulumiNullFieldException("baseImageTriggerType"),
        name = name ?: throw PulumiNullFieldException("name"),
        status = status,
        updateTriggerEndpoint = updateTriggerEndpoint,
        updateTriggerPayloadType = updateTriggerPayloadType,
    )
}
