@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.DockerBuildRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The parameters for a docker quick build.
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property arguments The collection of override arguments to be used when executing the run.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property dockerFilePath The Docker file path relative to the source location.
 * @property imageNames The fully qualified image names including the repository and tag.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property isPushEnabled The value of this property indicates whether the image built should be pushed to the registry or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property noCache The value of this property indicates whether the image cache is enabled or not.
 * @property platform The platform properties against which the run has to happen.
 * @property sourceLocation The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
 * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
 * @property target The name of the target build stage for the docker build.
 * @property timeout Run timeout in seconds.
 * @property type The type of the run request.
 * Expected value is 'DockerBuildRequest'.
 */
public data class DockerBuildRequestArgs(
    public val agentConfiguration: Output<AgentPropertiesArgs>? = null,
    public val agentPoolName: Output<String>? = null,
    public val arguments: Output<List<ArgumentArgs>>? = null,
    public val credentials: Output<CredentialsArgs>? = null,
    public val dockerFilePath: Output<String>,
    public val imageNames: Output<List<String>>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val isPushEnabled: Output<Boolean>? = null,
    public val logTemplate: Output<String>? = null,
    public val noCache: Output<Boolean>? = null,
    public val platform: Output<PlatformPropertiesArgs>,
    public val sourceLocation: Output<String>? = null,
    public val target: Output<String>? = null,
    public val timeout: Output<Int>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.DockerBuildRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.DockerBuildRequestArgs =
        com.pulumi.azurenative.containerregistry.inputs.DockerBuildRequestArgs.builder()
            .agentConfiguration(
                agentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .arguments(
                arguments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dockerFilePath(dockerFilePath.applyValue({ args0 -> args0 }))
            .imageNames(imageNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isPushEnabled(isPushEnabled?.applyValue({ args0 -> args0 }))
            .logTemplate(logTemplate?.applyValue({ args0 -> args0 }))
            .noCache(noCache?.applyValue({ args0 -> args0 }))
            .platform(platform.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceLocation(sourceLocation?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DockerBuildRequestArgs].
 */
@PulumiTagMarker
public class DockerBuildRequestArgsBuilder internal constructor() {
    private var agentConfiguration: Output<AgentPropertiesArgs>? = null

    private var agentPoolName: Output<String>? = null

    private var arguments: Output<List<ArgumentArgs>>? = null

    private var credentials: Output<CredentialsArgs>? = null

    private var dockerFilePath: Output<String>? = null

    private var imageNames: Output<List<String>>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var isPushEnabled: Output<Boolean>? = null

    private var logTemplate: Output<String>? = null

    private var noCache: Output<Boolean>? = null

    private var platform: Output<PlatformPropertiesArgs>? = null

    private var sourceLocation: Output<String>? = null

    private var target: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("wfkdghxsuyvccvic")
    public suspend fun agentConfiguration(`value`: Output<AgentPropertiesArgs>) {
        this.agentConfiguration = value
    }

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("mnxlomyjixrpxoah")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The collection of override arguments to be used when executing the run.
     */
    @JvmName("sjwtgmatnsfqyblu")
    public suspend fun arguments(`value`: Output<List<ArgumentArgs>>) {
        this.arguments = value
    }

    @JvmName("cmwlwiasghtpiisn")
    public suspend fun arguments(vararg values: Output<ArgumentArgs>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values The collection of override arguments to be used when executing the run.
     */
    @JvmName("cgkeknchlpuuhotl")
    public suspend fun arguments(values: List<Output<ArgumentArgs>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("mdtdccjykupiwmjd")
    public suspend fun credentials(`value`: Output<CredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The Docker file path relative to the source location.
     */
    @JvmName("djbdqqumeosiusuq")
    public suspend fun dockerFilePath(`value`: Output<String>) {
        this.dockerFilePath = value
    }

    /**
     * @param value The fully qualified image names including the repository and tag.
     */
    @JvmName("sfgdfnynrvwjqwbb")
    public suspend fun imageNames(`value`: Output<List<String>>) {
        this.imageNames = value
    }

    @JvmName("kreqhceywijrhtwn")
    public suspend fun imageNames(vararg values: Output<String>) {
        this.imageNames = Output.all(values.asList())
    }

    /**
     * @param values The fully qualified image names including the repository and tag.
     */
    @JvmName("monongedfdorrvhy")
    public suspend fun imageNames(values: List<Output<String>>) {
        this.imageNames = Output.all(values)
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("fcmyqmlytdwnighf")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value The value of this property indicates whether the image built should be pushed to the registry or not.
     */
    @JvmName("psdlrcentuxbmabr")
    public suspend fun isPushEnabled(`value`: Output<Boolean>) {
        this.isPushEnabled = value
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("hognuljndfsfbxeg")
    public suspend fun logTemplate(`value`: Output<String>) {
        this.logTemplate = value
    }

    /**
     * @param value The value of this property indicates whether the image cache is enabled or not.
     */
    @JvmName("icbatklvehghxhts")
    public suspend fun noCache(`value`: Output<Boolean>) {
        this.noCache = value
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("riyjyagoudetkcyw")
    public suspend fun platform(`value`: Output<PlatformPropertiesArgs>) {
        this.platform = value
    }

    /**
     * @param value The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     */
    @JvmName("fdsmymqnggtrdtfc")
    public suspend fun sourceLocation(`value`: Output<String>) {
        this.sourceLocation = value
    }

    /**
     * @param value The name of the target build stage for the docker build.
     */
    @JvmName("whermohpiawvjfwj")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("pybrknpikhromeav")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'DockerBuildRequest'.
     */
    @JvmName("canrummdfbooxwas")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("xbvmxcbpfisewdxu")
    public suspend fun agentConfiguration(`value`: AgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentConfiguration = mapped
    }

    /**
     * @param argument The machine configuration of the run agent.
     */
    @JvmName("vehnpdsbvvbwjyxl")
    public suspend fun agentConfiguration(argument: suspend AgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentConfiguration = mapped
    }

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("vbxqulusuvlmhlsf")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The collection of override arguments to be used when executing the run.
     */
    @JvmName("dsiumycfolutybpd")
    public suspend fun arguments(`value`: List<ArgumentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param argument The collection of override arguments to be used when executing the run.
     */
    @JvmName("xynnwyxsbwluuamu")
    public suspend fun arguments(argument: List<suspend ArgumentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ArgumentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param argument The collection of override arguments to be used when executing the run.
     */
    @JvmName("mhkthjsohrmcpmej")
    public suspend fun arguments(vararg argument: suspend ArgumentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ArgumentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param argument The collection of override arguments to be used when executing the run.
     */
    @JvmName("dhpbljquxjoyimqu")
    public suspend fun arguments(argument: suspend ArgumentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArgumentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param values The collection of override arguments to be used when executing the run.
     */
    @JvmName("qqaegwlbcosrvunp")
    public suspend fun arguments(vararg values: ArgumentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("cebonobdvwnlhevu")
    public suspend fun credentials(`value`: CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("vcheoxpbicfgxsxu")
    public suspend fun credentials(argument: suspend CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The Docker file path relative to the source location.
     */
    @JvmName("eyluqlstavofpwoc")
    public suspend fun dockerFilePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dockerFilePath = mapped
    }

    /**
     * @param value The fully qualified image names including the repository and tag.
     */
    @JvmName("vvajvsmrkmsyigqj")
    public suspend fun imageNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageNames = mapped
    }

    /**
     * @param values The fully qualified image names including the repository and tag.
     */
    @JvmName("bvmxtukihriqkfyt")
    public suspend fun imageNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageNames = mapped
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("lylckdegxwixujfe")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value The value of this property indicates whether the image built should be pushed to the registry or not.
     */
    @JvmName("lahouxjknuylfixx")
    public suspend fun isPushEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPushEnabled = mapped
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("tamfhdgkcyjomqse")
    public suspend fun logTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logTemplate = mapped
    }

    /**
     * @param value The value of this property indicates whether the image cache is enabled or not.
     */
    @JvmName("nwsahsbsfdpwrmdc")
    public suspend fun noCache(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noCache = mapped
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("ppswmvhfhqafbxgg")
    public suspend fun platform(`value`: PlatformPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The platform properties against which the run has to happen.
     */
    @JvmName("dresvwtehxwhanpf")
    public suspend fun platform(argument: suspend PlatformPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PlatformPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    /**
     * @param value The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     */
    @JvmName("dhnlviqbxyfceuxt")
    public suspend fun sourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceLocation = mapped
    }

    /**
     * @param value The name of the target build stage for the docker build.
     */
    @JvmName("ayymgsflklosngdx")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("kkilwafpmkxjxonq")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'DockerBuildRequest'.
     */
    @JvmName("lypxekexqvcbiagj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DockerBuildRequestArgs = DockerBuildRequestArgs(
        agentConfiguration = agentConfiguration,
        agentPoolName = agentPoolName,
        arguments = arguments,
        credentials = credentials,
        dockerFilePath = dockerFilePath ?: throw PulumiNullFieldException("dockerFilePath"),
        imageNames = imageNames,
        isArchiveEnabled = isArchiveEnabled,
        isPushEnabled = isPushEnabled,
        logTemplate = logTemplate,
        noCache = noCache,
        platform = platform ?: throw PulumiNullFieldException("platform"),
        sourceLocation = sourceLocation,
        target = target,
        timeout = timeout,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
