@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.FileTaskRunRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The request parameters for a scheduling run against a task file.
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property platform The platform properties against which the run has to happen.
 * @property sourceLocation The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
 * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
 * @property taskFilePath The template/definition file path relative to the source.
 * @property timeout Run timeout in seconds.
 * @property type The type of the run request.
 * Expected value is 'FileTaskRunRequest'.
 * @property values The collection of overridable values that can be passed when running a task.
 * @property valuesFilePath The values/parameters file path relative to the source.
 */
public data class FileTaskRunRequestArgs(
    public val agentConfiguration: Output<AgentPropertiesArgs>? = null,
    public val agentPoolName: Output<String>? = null,
    public val credentials: Output<CredentialsArgs>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val logTemplate: Output<String>? = null,
    public val platform: Output<PlatformPropertiesArgs>,
    public val sourceLocation: Output<String>? = null,
    public val taskFilePath: Output<String>,
    public val timeout: Output<Int>? = null,
    public val type: Output<String>,
    public val values: Output<List<SetValueArgs>>? = null,
    public val valuesFilePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.FileTaskRunRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.FileTaskRunRequestArgs =
        com.pulumi.azurenative.containerregistry.inputs.FileTaskRunRequestArgs.builder()
            .agentConfiguration(
                agentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .logTemplate(logTemplate?.applyValue({ args0 -> args0 }))
            .platform(platform.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceLocation(sourceLocation?.applyValue({ args0 -> args0 }))
            .taskFilePath(taskFilePath.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .valuesFilePath(valuesFilePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileTaskRunRequestArgs].
 */
@PulumiTagMarker
public class FileTaskRunRequestArgsBuilder internal constructor() {
    private var agentConfiguration: Output<AgentPropertiesArgs>? = null

    private var agentPoolName: Output<String>? = null

    private var credentials: Output<CredentialsArgs>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var logTemplate: Output<String>? = null

    private var platform: Output<PlatformPropertiesArgs>? = null

    private var sourceLocation: Output<String>? = null

    private var taskFilePath: Output<String>? = null

    private var timeout: Output<Int>? = null

    private var type: Output<String>? = null

    private var values: Output<List<SetValueArgs>>? = null

    private var valuesFilePath: Output<String>? = null

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("cqkynrriotcotlec")
    public suspend fun agentConfiguration(`value`: Output<AgentPropertiesArgs>) {
        this.agentConfiguration = value
    }

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("sdwxfldwgbgjxtgi")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("hhbkbaswdkfvfqpv")
    public suspend fun credentials(`value`: Output<CredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("jjhbaqcesdtrewft")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("ccmgrclprqiedtbs")
    public suspend fun logTemplate(`value`: Output<String>) {
        this.logTemplate = value
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("anbtuwmfhstlmwdh")
    public suspend fun platform(`value`: Output<PlatformPropertiesArgs>) {
        this.platform = value
    }

    /**
     * @param value The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     */
    @JvmName("bjiouwtdrbwrilpn")
    public suspend fun sourceLocation(`value`: Output<String>) {
        this.sourceLocation = value
    }

    /**
     * @param value The template/definition file path relative to the source.
     */
    @JvmName("irbmaxbwwultauqy")
    public suspend fun taskFilePath(`value`: Output<String>) {
        this.taskFilePath = value
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("bcxrvlxphcqejmhm")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'FileTaskRunRequest'.
     */
    @JvmName("fwjcuwnnaqggauae")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("olgktenhjbuqibxk")
    public suspend fun values(`value`: Output<List<SetValueArgs>>) {
        this.values = value
    }

    @JvmName("pbtrrwkgsepigrka")
    public suspend fun values(vararg values: Output<SetValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("ohuqqvcnckfbidee")
    public suspend fun values(values: List<Output<SetValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The values/parameters file path relative to the source.
     */
    @JvmName("lwrfghmkfkavbthn")
    public suspend fun valuesFilePath(`value`: Output<String>) {
        this.valuesFilePath = value
    }

    /**
     * @param value The machine configuration of the run agent.
     */
    @JvmName("ungyiolkyovmxvmh")
    public suspend fun agentConfiguration(`value`: AgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentConfiguration = mapped
    }

    /**
     * @param argument The machine configuration of the run agent.
     */
    @JvmName("qkfijsrgnapyytlr")
    public suspend fun agentConfiguration(argument: suspend AgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentConfiguration = mapped
    }

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("omksypducmxwhxdm")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("tmhihfsidrxxwtdg")
    public suspend fun credentials(`value`: CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The properties that describes a set of credentials that will be used when this run is invoked.
     */
    @JvmName("jxtinxodbfruvqlm")
    public suspend fun credentials(argument: suspend CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("rehnlqxgqsnnubtx")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("otknuvabwkmksicf")
    public suspend fun logTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logTemplate = mapped
    }

    /**
     * @param value The platform properties against which the run has to happen.
     */
    @JvmName("yhhgqfkdckrhfblf")
    public suspend fun platform(`value`: PlatformPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.platform = mapped
    }

    /**
     * @param argument The platform properties against which the run has to happen.
     */
    @JvmName("xumnibitudrrhxmp")
    public suspend fun platform(argument: suspend PlatformPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PlatformPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.platform = mapped
    }

    /**
     * @param value The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
     * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
     */
    @JvmName("pqpjsuwaehuodsua")
    public suspend fun sourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceLocation = mapped
    }

    /**
     * @param value The template/definition file path relative to the source.
     */
    @JvmName("ygvyjwyfptsqvivk")
    public suspend fun taskFilePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskFilePath = mapped
    }

    /**
     * @param value Run timeout in seconds.
     */
    @JvmName("usxwkvbrasxriiqn")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'FileTaskRunRequest'.
     */
    @JvmName("iigqlxkmujwoqccx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("jvgwlqtxnpxxgsmj")
    public suspend fun values(`value`: List<SetValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("ciifnmlrktqjmnwi")
    public suspend fun values(argument: List<suspend SetValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("bviyneebgdmtkduv")
    public suspend fun values(vararg argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("togeijafjoonjgqn")
    public suspend fun values(argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SetValueArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("dohkflksykobwnbo")
    public suspend fun values(vararg values: SetValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param value The values/parameters file path relative to the source.
     */
    @JvmName("bowynnsuemijhaah")
    public suspend fun valuesFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valuesFilePath = mapped
    }

    internal fun build(): FileTaskRunRequestArgs = FileTaskRunRequestArgs(
        agentConfiguration = agentConfiguration,
        agentPoolName = agentPoolName,
        credentials = credentials,
        isArchiveEnabled = isArchiveEnabled,
        logTemplate = logTemplate,
        platform = platform ?: throw PulumiNullFieldException("platform"),
        sourceLocation = sourceLocation,
        taskFilePath = taskFilePath ?: throw PulumiNullFieldException("taskFilePath"),
        timeout = timeout,
        type = type ?: throw PulumiNullFieldException("type"),
        values = values,
        valuesFilePath = valuesFilePath,
    )
}
