@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.FileTaskStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a task step.
 * @property contextAccessToken The token (git PAT or SAS token of storage account blob) associated with the context for a step.
 * @property contextPath The URL(absolute or relative) of the source context for the task step.
 * @property taskFilePath The task template/definition file path relative to the source context.
 * @property type The type of the step.
 * Expected value is 'FileTask'.
 * @property values The collection of overridable values that can be passed when running a task.
 * @property valuesFilePath The task values/parameters file path relative to the source context.
 */
public data class FileTaskStepArgs(
    public val contextAccessToken: Output<String>? = null,
    public val contextPath: Output<String>? = null,
    public val taskFilePath: Output<String>,
    public val type: Output<String>,
    public val values: Output<List<SetValueArgs>>? = null,
    public val valuesFilePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.FileTaskStepArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.FileTaskStepArgs =
        com.pulumi.azurenative.containerregistry.inputs.FileTaskStepArgs.builder()
            .contextAccessToken(contextAccessToken?.applyValue({ args0 -> args0 }))
            .contextPath(contextPath?.applyValue({ args0 -> args0 }))
            .taskFilePath(taskFilePath.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .values(values?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .valuesFilePath(valuesFilePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileTaskStepArgs].
 */
@PulumiTagMarker
public class FileTaskStepArgsBuilder internal constructor() {
    private var contextAccessToken: Output<String>? = null

    private var contextPath: Output<String>? = null

    private var taskFilePath: Output<String>? = null

    private var type: Output<String>? = null

    private var values: Output<List<SetValueArgs>>? = null

    private var valuesFilePath: Output<String>? = null

    /**
     * @param value The token (git PAT or SAS token of storage account blob) associated with the context for a step.
     */
    @JvmName("qdvfutnfhjlvicgm")
    public suspend fun contextAccessToken(`value`: Output<String>) {
        this.contextAccessToken = value
    }

    /**
     * @param value The URL(absolute or relative) of the source context for the task step.
     */
    @JvmName("tonpkcmoxgjagmgo")
    public suspend fun contextPath(`value`: Output<String>) {
        this.contextPath = value
    }

    /**
     * @param value The task template/definition file path relative to the source context.
     */
    @JvmName("ghwdfsstqxeudouw")
    public suspend fun taskFilePath(`value`: Output<String>) {
        this.taskFilePath = value
    }

    /**
     * @param value The type of the step.
     * Expected value is 'FileTask'.
     */
    @JvmName("bfslpvhwuumjxxue")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("qpudjofksemugwhb")
    public suspend fun values(`value`: Output<List<SetValueArgs>>) {
        this.values = value
    }

    @JvmName("bkrseuoohjvjkbji")
    public suspend fun values(vararg values: Output<SetValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("fsviesrbyiepiabw")
    public suspend fun values(values: List<Output<SetValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The task values/parameters file path relative to the source context.
     */
    @JvmName("awfhcplyxujjaife")
    public suspend fun valuesFilePath(`value`: Output<String>) {
        this.valuesFilePath = value
    }

    /**
     * @param value The token (git PAT or SAS token of storage account blob) associated with the context for a step.
     */
    @JvmName("biqrehabasmauhxu")
    public suspend fun contextAccessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextAccessToken = mapped
    }

    /**
     * @param value The URL(absolute or relative) of the source context for the task step.
     */
    @JvmName("mjlgakqhxeleowcu")
    public suspend fun contextPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextPath = mapped
    }

    /**
     * @param value The task template/definition file path relative to the source context.
     */
    @JvmName("dfqkwfqlrxcvgpya")
    public suspend fun taskFilePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskFilePath = mapped
    }

    /**
     * @param value The type of the step.
     * Expected value is 'FileTask'.
     */
    @JvmName("oyixjobpsodkcqem")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The collection of overridable values that can be passed when running a task.
     */
    @JvmName("mhurbbtvoxwtpftf")
    public suspend fun values(`value`: List<SetValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("qmjoxfddkhplxubx")
    public suspend fun values(argument: List<suspend SetValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("cmrwhigubyxfwmxd")
    public suspend fun values(vararg argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a task.
     */
    @JvmName("ffnoptrhvnckpcla")
    public suspend fun values(argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SetValueArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values The collection of overridable values that can be passed when running a task.
     */
    @JvmName("yviyndvftdlrycxx")
    public suspend fun values(vararg values: SetValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param value The task values/parameters file path relative to the source context.
     */
    @JvmName("ubyffmrqmfqhaelp")
    public suspend fun valuesFilePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valuesFilePath = mapped
    }

    internal fun build(): FileTaskStepArgs = FileTaskStepArgs(
        contextAccessToken = contextAccessToken,
        contextPath = contextPath,
        taskFilePath = taskFilePath ?: throw PulumiNullFieldException("taskFilePath"),
        type = type ?: throw PulumiNullFieldException("type"),
        values = values,
        valuesFilePath = valuesFilePath,
    )
}
