@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetCredentialSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property credentialSetName The name of the credential set.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCredentialSetPlainArgs(
    public val credentialSetName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetCredentialSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetCredentialSetPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetCredentialSetPlainArgs.builder()
            .credentialSetName(credentialSetName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCredentialSetPlainArgs].
 */
@PulumiTagMarker
public class GetCredentialSetPlainArgsBuilder internal constructor() {
    private var credentialSetName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the credential set.
     */
    @JvmName("grncmxvvhccjiopi")
    public suspend fun credentialSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.credentialSetName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("gofiuhmtiuacmece")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ryetcrtxcrupjmta")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCredentialSetPlainArgs = GetCredentialSetPlainArgs(
        credentialSetName = credentialSetName ?: throw PulumiNullFieldException("credentialSetName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
