@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetExportPipelinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property exportPipelineName The name of the export pipeline.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetExportPipelinePlainArgs(
    public val exportPipelineName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetExportPipelinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetExportPipelinePlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetExportPipelinePlainArgs.builder()
            .exportPipelineName(exportPipelineName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExportPipelinePlainArgs].
 */
@PulumiTagMarker
public class GetExportPipelinePlainArgsBuilder internal constructor() {
    private var exportPipelineName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the export pipeline.
     */
    @JvmName("frdggegftvwyvhtb")
    public suspend fun exportPipelineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.exportPipelineName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("wrgtvvhsspunttdj")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("flypeoqttosflhwo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExportPipelinePlainArgs = GetExportPipelinePlainArgs(
        exportPipelineName = exportPipelineName ?: throw PulumiNullFieldException("exportPipelineName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
