@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property identity The client id of the identity which will be used to access key vault.
 * @property keyIdentifier Key vault uri to access the encryption key.
 */
public data class KeyVaultPropertiesArgs(
    public val identity: Output<String>? = null,
    public val keyIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.KeyVaultPropertiesArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0 }))
            .keyIdentifier(keyIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var identity: Output<String>? = null

    private var keyIdentifier: Output<String>? = null

    /**
     * @param value The client id of the identity which will be used to access key vault.
     */
    @JvmName("fcbpfwwqnwcxxouv")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value Key vault uri to access the encryption key.
     */
    @JvmName("xbvnjvuyllifhmvp")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value The client id of the identity which will be used to access key vault.
     */
    @JvmName("kgvgktrdpvaicmpq")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Key vault uri to access the encryption key.
     */
    @JvmName("obhbhpowefddjluq")
    public suspend fun keyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        identity = identity,
        keyIdentifier = keyIdentifier,
    )
}
