@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ListRegistryBuildSourceUploadUrlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 */
public data class ListRegistryBuildSourceUploadUrlPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ListRegistryBuildSourceUploadUrlPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.ListRegistryBuildSourceUploadUrlPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.ListRegistryBuildSourceUploadUrlPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListRegistryBuildSourceUploadUrlPlainArgs].
 */
@PulumiTagMarker
public class ListRegistryBuildSourceUploadUrlPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("romrxvuvmebqdssr")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("krmjuunynpunemve")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListRegistryBuildSourceUploadUrlPlainArgs =
        ListRegistryBuildSourceUploadUrlPlainArgs(
            registryName = registryName ?: throw PulumiNullFieldException("registryName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
