@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ListRunLogSasUrlPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property runId The run ID.
 */
public data class ListRunLogSasUrlPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
    public val runId: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ListRunLogSasUrlPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ListRunLogSasUrlPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.ListRunLogSasUrlPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runId(runId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListRunLogSasUrlPlainArgs].
 */
@PulumiTagMarker
public class ListRunLogSasUrlPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var runId: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("orjmnhfriyaqekgk")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("purntcukqecitpmm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The run ID.
     */
    @JvmName("chumvxjlejbgxhtt")
    public suspend fun runId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runId = mapped
    }

    internal fun build(): ListRunLogSasUrlPlainArgs = ListRunLogSasUrlPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        runId = runId ?: throw PulumiNullFieldException("runId"),
    )
}
