@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.LoggingPropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.AuditLogStatus
import com.pulumi.azurenative.containerregistry.kotlin.enums.LogLevel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The logging properties of the connected registry.
 * @property auditLogStatus Indicates whether audit logs are enabled on the connected registry.
 * @property logLevel The verbosity of logs persisted on the connected registry.
 */
public data class LoggingPropertiesArgs(
    public val auditLogStatus: Output<Either<String, AuditLogStatus>>? = null,
    public val logLevel: Output<Either<String, LogLevel>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.LoggingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.LoggingPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.LoggingPropertiesArgs.builder()
            .auditLogStatus(
                auditLogStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logLevel(
                logLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [LoggingPropertiesArgs].
 */
@PulumiTagMarker
public class LoggingPropertiesArgsBuilder internal constructor() {
    private var auditLogStatus: Output<Either<String, AuditLogStatus>>? = null

    private var logLevel: Output<Either<String, LogLevel>>? = null

    /**
     * @param value Indicates whether audit logs are enabled on the connected registry.
     */
    @JvmName("jbpmvqoruhdnwmeb")
    public suspend fun auditLogStatus(`value`: Output<Either<String, AuditLogStatus>>) {
        this.auditLogStatus = value
    }

    /**
     * @param value The verbosity of logs persisted on the connected registry.
     */
    @JvmName("rwwjavitxgnekwrj")
    public suspend fun logLevel(`value`: Output<Either<String, LogLevel>>) {
        this.logLevel = value
    }

    /**
     * @param value Indicates whether audit logs are enabled on the connected registry.
     */
    @JvmName("iwjspuhxkuwqatfm")
    public suspend fun auditLogStatus(`value`: Either<String, AuditLogStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditLogStatus = mapped
    }

    /**
     * @param value Indicates whether audit logs are enabled on the connected registry.
     */
    @JvmName("drwqphseluqxsunb")
    public fun auditLogStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuditLogStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auditLogStatus = mapped
    }

    /**
     * @param value Indicates whether audit logs are enabled on the connected registry.
     */
    @JvmName("aqrxbwedgabgjqcu")
    public fun auditLogStatus(`value`: AuditLogStatus) {
        val toBeMapped = Either.ofRight<String, AuditLogStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auditLogStatus = mapped
    }

    /**
     * @param value The verbosity of logs persisted on the connected registry.
     */
    @JvmName("efjcuipkvvbrdnai")
    public suspend fun logLevel(`value`: Either<String, LogLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value The verbosity of logs persisted on the connected registry.
     */
    @JvmName("gspocdncryryigkb")
    public fun logLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value The verbosity of logs persisted on the connected registry.
     */
    @JvmName("ddxogrwatnwaqbqf")
    public fun logLevel(`value`: LogLevel) {
        val toBeMapped = Either.ofRight<String, LogLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    internal fun build(): LoggingPropertiesArgs = LoggingPropertiesArgs(
        auditLogStatus = auditLogStatus,
        logLevel = logLevel,
    )
}
