@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.OverrideTaskStepPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arguments Gets or sets the collection of override arguments to be used when
 * executing a build step.
 * @property contextPath The source context against which run has to be queued.
 * @property file The file against which run has to be queued.
 * @property target The name of the target build stage for the docker build.
 * @property updateTriggerToken Base64 encoded update trigger token that will be attached with the base image trigger webhook.
 * @property values The collection of overridable values that can be passed when running a Task.
 */
public data class OverrideTaskStepPropertiesArgs(
    public val arguments: Output<List<ArgumentArgs>>? = null,
    public val contextPath: Output<String>? = null,
    public val `file`: Output<String>? = null,
    public val target: Output<String>? = null,
    public val updateTriggerToken: Output<String>? = null,
    public val values: Output<List<SetValueArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.OverrideTaskStepPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.OverrideTaskStepPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.OverrideTaskStepPropertiesArgs.builder()
            .arguments(
                arguments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .contextPath(contextPath?.applyValue({ args0 -> args0 }))
            .`file`(`file`?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .updateTriggerToken(updateTriggerToken?.applyValue({ args0 -> args0 }))
            .values(
                values?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [OverrideTaskStepPropertiesArgs].
 */
@PulumiTagMarker
public class OverrideTaskStepPropertiesArgsBuilder internal constructor() {
    private var arguments: Output<List<ArgumentArgs>>? = null

    private var contextPath: Output<String>? = null

    private var `file`: Output<String>? = null

    private var target: Output<String>? = null

    private var updateTriggerToken: Output<String>? = null

    private var values: Output<List<SetValueArgs>>? = null

    /**
     * @param value Gets or sets the collection of override arguments to be used when
     * executing a build step.
     */
    @JvmName("jrkupvrrhvodxvqq")
    public suspend fun arguments(`value`: Output<List<ArgumentArgs>>) {
        this.arguments = value
    }

    @JvmName("txbmgiasfvpgqeof")
    public suspend fun arguments(vararg values: Output<ArgumentArgs>) {
        this.arguments = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the collection of override arguments to be used when
     * executing a build step.
     */
    @JvmName("lrcefacgcpyblsdc")
    public suspend fun arguments(values: List<Output<ArgumentArgs>>) {
        this.arguments = Output.all(values)
    }

    /**
     * @param value The source context against which run has to be queued.
     */
    @JvmName("fdynugqghjtlohdy")
    public suspend fun contextPath(`value`: Output<String>) {
        this.contextPath = value
    }

    /**
     * @param value The file against which run has to be queued.
     */
    @JvmName("fijqmfrhdsiwsonr")
    public suspend fun `file`(`value`: Output<String>) {
        this.`file` = value
    }

    /**
     * @param value The name of the target build stage for the docker build.
     */
    @JvmName("sumwmqsuunhqfxsl")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Base64 encoded update trigger token that will be attached with the base image trigger webhook.
     */
    @JvmName("wrtdciyotfvkwcsa")
    public suspend fun updateTriggerToken(`value`: Output<String>) {
        this.updateTriggerToken = value
    }

    /**
     * @param value The collection of overridable values that can be passed when running a Task.
     */
    @JvmName("bjnrhonaceoghxll")
    public suspend fun values(`value`: Output<List<SetValueArgs>>) {
        this.values = value
    }

    @JvmName("khwggnnvkktuswml")
    public suspend fun values(vararg values: Output<SetValueArgs>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The collection of overridable values that can be passed when running a Task.
     */
    @JvmName("umgraqemfmkndwht")
    public suspend fun values(values: List<Output<SetValueArgs>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Gets or sets the collection of override arguments to be used when
     * executing a build step.
     */
    @JvmName("aekbwnngynskxrna")
    public suspend fun arguments(`value`: List<ArgumentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param argument Gets or sets the collection of override arguments to be used when
     * executing a build step.
     */
    @JvmName("txvjucfrfydvetsa")
    public suspend fun arguments(argument: List<suspend ArgumentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ArgumentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param argument Gets or sets the collection of override arguments to be used when
     * executing a build step.
     */
    @JvmName("gyineddsrncfraft")
    public suspend fun arguments(vararg argument: suspend ArgumentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ArgumentArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param argument Gets or sets the collection of override arguments to be used when
     * executing a build step.
     */
    @JvmName("pepcbflwxqviutgi")
    public suspend fun arguments(argument: suspend ArgumentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArgumentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.arguments = mapped
    }

    /**
     * @param values Gets or sets the collection of override arguments to be used when
     * executing a build step.
     */
    @JvmName("tttfidjjwewodjde")
    public suspend fun arguments(vararg values: ArgumentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value The source context against which run has to be queued.
     */
    @JvmName("xmbwylbryqdcbmht")
    public suspend fun contextPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contextPath = mapped
    }

    /**
     * @param value The file against which run has to be queued.
     */
    @JvmName("ntmgxrurndrsxexh")
    public suspend fun `file`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param value The name of the target build stage for the docker build.
     */
    @JvmName("aulvtyeqysscdjkb")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Base64 encoded update trigger token that will be attached with the base image trigger webhook.
     */
    @JvmName("sbdgyryrskxfrssi")
    public suspend fun updateTriggerToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateTriggerToken = mapped
    }

    /**
     * @param value The collection of overridable values that can be passed when running a Task.
     */
    @JvmName("grqiagkcdrjiesdd")
    public suspend fun values(`value`: List<SetValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a Task.
     */
    @JvmName("gjlkjjlseapwvypw")
    public suspend fun values(argument: List<suspend SetValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a Task.
     */
    @JvmName("phgcgedcdgeoxsyl")
    public suspend fun values(vararg argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SetValueArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param argument The collection of overridable values that can be passed when running a Task.
     */
    @JvmName("gvamrlxeohaditsp")
    public suspend fun values(argument: suspend SetValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SetValueArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.values = mapped
    }

    /**
     * @param values The collection of overridable values that can be passed when running a Task.
     */
    @JvmName("dxblvjliliwmrbqx")
    public suspend fun values(vararg values: SetValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): OverrideTaskStepPropertiesArgs = OverrideTaskStepPropertiesArgs(
        arguments = arguments,
        contextPath = contextPath,
        `file` = `file`,
        target = target,
        updateTriggerToken = updateTriggerToken,
        values = values,
    )
}
