@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PipelineRunTargetPropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PipelineRunTargetType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the target.
 * @property type The type of the target.
 */
public data class PipelineRunTargetPropertiesArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, PipelineRunTargetType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PipelineRunTargetPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.PipelineRunTargetPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.PipelineRunTargetPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineRunTargetPropertiesArgs].
 */
@PulumiTagMarker
public class PipelineRunTargetPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, PipelineRunTargetType>>? = null

    /**
     * @param value The name of the target.
     */
    @JvmName("ooojjqhfknhynkra")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the target.
     */
    @JvmName("ykraplgrbbsxgltj")
    public suspend fun type(`value`: Output<Either<String, PipelineRunTargetType>>) {
        this.type = value
    }

    /**
     * @param value The name of the target.
     */
    @JvmName("pollhslhsbctgabm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the target.
     */
    @JvmName("nwksjhqiqwylgagq")
    public suspend fun type(`value`: Either<String, PipelineRunTargetType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the target.
     */
    @JvmName("hjrjnkxakcmjmdmf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PipelineRunTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the target.
     */
    @JvmName("nhbfjsfdrmxhvbbg")
    public fun type(`value`: PipelineRunTargetType) {
        val toBeMapped = Either.ofRight<String, PipelineRunTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineRunTargetPropertiesArgs = PipelineRunTargetPropertiesArgs(
        name = name,
        type = type,
    )
}
