@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.QuarantinePolicyArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PolicyStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The quarantine policy for a container registry.
 * @property status The value that indicates whether the policy is enabled or not.
 */
public data class QuarantinePolicyArgs(
    public val status: Output<Either<String, PolicyStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.QuarantinePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.QuarantinePolicyArgs =
        com.pulumi.azurenative.containerregistry.inputs.QuarantinePolicyArgs.builder()
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [QuarantinePolicyArgs].
 */
@PulumiTagMarker
public class QuarantinePolicyArgsBuilder internal constructor() {
    private var status: Output<Either<String, PolicyStatus>>? = null

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("gadlnkokmvffsrgt")
    public suspend fun status(`value`: Output<Either<String, PolicyStatus>>) {
        this.status = value
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("bwlwxiaoaeppugir")
    public suspend fun status(`value`: Either<String, PolicyStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("fwaxjpfxtmyvdsoc")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The value that indicates whether the policy is enabled or not.
     */
    @JvmName("ecvtoxjtnvqxkgmf")
    public fun status(`value`: PolicyStatus) {
        val toBeMapped = Either.ofRight<String, PolicyStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): QuarantinePolicyArgs = QuarantinePolicyArgs(
        status = status,
    )
}
