@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.SetValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a overridable value that can be passed to a task template.
 * @property isSecret Flag to indicate whether the value represents a secret or not.
 * @property name The name of the overridable value.
 * @property value The overridable value.
 */
public data class SetValueArgs(
    public val isSecret: Output<Boolean>? = null,
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.SetValueArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.SetValueArgs =
        com.pulumi.azurenative.containerregistry.inputs.SetValueArgs.builder()
            .isSecret(isSecret?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SetValueArgs].
 */
@PulumiTagMarker
public class SetValueArgsBuilder internal constructor() {
    private var isSecret: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Flag to indicate whether the value represents a secret or not.
     */
    @JvmName("mbnbalfxbqrmkusw")
    public suspend fun isSecret(`value`: Output<Boolean>) {
        this.isSecret = value
    }

    /**
     * @param value The name of the overridable value.
     */
    @JvmName("nedwrrgshsrbwpgj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The overridable value.
     */
    @JvmName("qgywvqoycffehfvl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Flag to indicate whether the value represents a secret or not.
     */
    @JvmName("dffgkjaebidckcdt")
    public suspend fun isSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSecret = mapped
    }

    /**
     * @param value The name of the overridable value.
     */
    @JvmName("phlsdyoddgesmbxn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The overridable value.
     */
    @JvmName("oplroaacmcxkkrit")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SetValueArgs = SetValueArgs(
        isSecret = isSecret,
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
