@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.SourceRegistryCredentialsArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.SourceRegistryLoginMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the credential parameters for accessing the source registry.
 * @property loginMode The authentication mode which determines the source registry login scope. The credentials for the source registry
 * will be generated using the given scope. These credentials will be used to login to
 * the source registry during the run.
 */
public data class SourceRegistryCredentialsArgs(
    public val loginMode: Output<Either<String, SourceRegistryLoginMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.SourceRegistryCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.containerregistry.inputs.SourceRegistryCredentialsArgs =
        com.pulumi.azurenative.containerregistry.inputs.SourceRegistryCredentialsArgs.builder()
            .loginMode(
                loginMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SourceRegistryCredentialsArgs].
 */
@PulumiTagMarker
public class SourceRegistryCredentialsArgsBuilder internal constructor() {
    private var loginMode: Output<Either<String, SourceRegistryLoginMode>>? = null

    /**
     * @param value The authentication mode which determines the source registry login scope. The credentials for the source registry
     * will be generated using the given scope. These credentials will be used to login to
     * the source registry during the run.
     */
    @JvmName("yysuhqbpgpjwriro")
    public suspend fun loginMode(`value`: Output<Either<String, SourceRegistryLoginMode>>) {
        this.loginMode = value
    }

    /**
     * @param value The authentication mode which determines the source registry login scope. The credentials for the source registry
     * will be generated using the given scope. These credentials will be used to login to
     * the source registry during the run.
     */
    @JvmName("fhoynpssphodiond")
    public suspend fun loginMode(`value`: Either<String, SourceRegistryLoginMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginMode = mapped
    }

    /**
     * @param value The authentication mode which determines the source registry login scope. The credentials for the source registry
     * will be generated using the given scope. These credentials will be used to login to
     * the source registry during the run.
     */
    @JvmName("xtwgdcumygpcnqkn")
    public fun loginMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SourceRegistryLoginMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loginMode = mapped
    }

    /**
     * @param value The authentication mode which determines the source registry login scope. The credentials for the source registry
     * will be generated using the given scope. These credentials will be used to login to
     * the source registry during the run.
     */
    @JvmName("qifvuikmccicbioc")
    public fun loginMode(`value`: SourceRegistryLoginMode) {
        val toBeMapped = Either.ofRight<String, SourceRegistryLoginMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loginMode = mapped
    }

    internal fun build(): SourceRegistryCredentialsArgs = SourceRegistryCredentialsArgs(
        loginMode = loginMode,
    )
}
