@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.TaskRunRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The parameters for a task run request.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property overrideTaskStepProperties Set of overridable parameters that can be passed when running a Task.
 * @property taskId The resource ID of task against which run has to be queued.
 * @property type The type of the run request.
 * Expected value is 'TaskRunRequest'.
 */
public data class TaskRunRequestArgs(
    public val agentPoolName: Output<String>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val logTemplate: Output<String>? = null,
    public val overrideTaskStepProperties: Output<OverrideTaskStepPropertiesArgs>? = null,
    public val taskId: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.TaskRunRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.TaskRunRequestArgs =
        com.pulumi.azurenative.containerregistry.inputs.TaskRunRequestArgs.builder()
            .agentPoolName(agentPoolName?.applyValue({ args0 -> args0 }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .logTemplate(logTemplate?.applyValue({ args0 -> args0 }))
            .overrideTaskStepProperties(
                overrideTaskStepProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .taskId(taskId.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskRunRequestArgs].
 */
@PulumiTagMarker
public class TaskRunRequestArgsBuilder internal constructor() {
    private var agentPoolName: Output<String>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var logTemplate: Output<String>? = null

    private var overrideTaskStepProperties: Output<OverrideTaskStepPropertiesArgs>? = null

    private var taskId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("luemvypoeiwwcuey")
    public suspend fun agentPoolName(`value`: Output<String>) {
        this.agentPoolName = value
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("skmshoynrprurrrw")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("mwhawllawkogfkot")
    public suspend fun logTemplate(`value`: Output<String>) {
        this.logTemplate = value
    }

    /**
     * @param value Set of overridable parameters that can be passed when running a Task.
     */
    @JvmName("dpdirfemgebwyiov")
    public suspend fun overrideTaskStepProperties(`value`: Output<OverrideTaskStepPropertiesArgs>) {
        this.overrideTaskStepProperties = value
    }

    /**
     * @param value The resource ID of task against which run has to be queued.
     */
    @JvmName("bafcllfcgfgsoyxx")
    public suspend fun taskId(`value`: Output<String>) {
        this.taskId = value
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'TaskRunRequest'.
     */
    @JvmName("dalmcmoxerwctflu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The dedicated agent pool for the run.
     */
    @JvmName("chvbbymxtluhdkck")
    public suspend fun agentPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolName = mapped
    }

    /**
     * @param value The value that indicates whether archiving is enabled for the run or not.
     */
    @JvmName("xyqvnqlvcaxsfhiq")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value The template that describes the repository and tag information for run log artifact.
     */
    @JvmName("vlnysjyymmtsmikr")
    public suspend fun logTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logTemplate = mapped
    }

    /**
     * @param value Set of overridable parameters that can be passed when running a Task.
     */
    @JvmName("nunnpkhpvclybslf")
    public suspend fun overrideTaskStepProperties(`value`: OverrideTaskStepPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideTaskStepProperties = mapped
    }

    /**
     * @param argument Set of overridable parameters that can be passed when running a Task.
     */
    @JvmName("mjkpaqvwkanssjyh")
    public suspend
    fun overrideTaskStepProperties(argument: suspend OverrideTaskStepPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = OverrideTaskStepPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.overrideTaskStepProperties = mapped
    }

    /**
     * @param value The resource ID of task against which run has to be queued.
     */
    @JvmName("podpfdgewskbqslo")
    public suspend fun taskId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskId = mapped
    }

    /**
     * @param value The type of the run request.
     * Expected value is 'TaskRunRequest'.
     */
    @JvmName("wcdlfwksnxmnexyh")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TaskRunRequestArgs = TaskRunRequestArgs(
        agentPoolName = agentPoolName,
        isArchiveEnabled = isArchiveEnabled,
        logTemplate = logTemplate,
        overrideTaskStepProperties = overrideTaskStepProperties,
        taskId = taskId ?: throw PulumiNullFieldException("taskId"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
