@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.TimerTriggerArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.TriggerStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a timer trigger.
 * @property name The name of the trigger.
 * @property schedule The CRON expression for the task schedule
 * @property status The current status of trigger.
 */
public data class TimerTriggerArgs(
    public val name: Output<String>,
    public val schedule: Output<String>,
    public val status: Output<Either<String, TriggerStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.TimerTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.TimerTriggerArgs =
        com.pulumi.azurenative.containerregistry.inputs.TimerTriggerArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .schedule(schedule.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [TimerTriggerArgs].
 */
@PulumiTagMarker
public class TimerTriggerArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var schedule: Output<String>? = null

    private var status: Output<Either<String, TriggerStatus>>? = null

    /**
     * @param value The name of the trigger.
     */
    @JvmName("byltnyqjmlcojvdg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The CRON expression for the task schedule
     */
    @JvmName("mwxotkyunlynoijf")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("arwelxwfmhtkogko")
    public suspend fun status(`value`: Output<Either<String, TriggerStatus>>) {
        this.status = value
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("qwtjwusoomkulqyp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The CRON expression for the task schedule
     */
    @JvmName("xbsrqygdgeqaexcm")
    public suspend fun schedule(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("xcutmwcjqutoftqx")
    public suspend fun status(`value`: Either<String, TriggerStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("fwgtnxijxxcjcbgu")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("ukssjddarymuekvu")
    public fun status(`value`: TriggerStatus) {
        val toBeMapped = Either.ofRight<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): TimerTriggerArgs = TimerTriggerArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        schedule = schedule ?: throw PulumiNullFieldException("schedule"),
        status = status,
    )
}
