@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties that describe a base image dependency.
 * @property digest The sha256-based digest of the image manifest.
 * @property registry The registry login server.
 * @property repository The repository name.
 * @property tag The tag name.
 * @property type The type of the base image dependency.
 */
public data class BaseImageDependencyResponse(
    public val digest: String? = null,
    public val registry: String? = null,
    public val repository: String? = null,
    public val tag: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.BaseImageDependencyResponse):
            BaseImageDependencyResponse = BaseImageDependencyResponse(
            digest = javaType.digest().map({ args0 -> args0 }).orElse(null),
            registry = javaType.registry().map({ args0 -> args0 }).orElse(null),
            repository = javaType.repository().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
