@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The event response message received from the service URI.
 * @property content The content of the event response message.
 * @property headers The headers of the event response message.
 * @property reasonPhrase The reason phrase of the event response message.
 * @property statusCode The status code of the event response message.
 * @property version The HTTP message version.
 */
public data class EventResponseMessageResponse(
    public val content: String? = null,
    public val headers: Map<String, String>? = null,
    public val reasonPhrase: String? = null,
    public val statusCode: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.EventResponseMessageResponse):
            EventResponseMessageResponse = EventResponseMessageResponse(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            reasonPhrase = javaType.reasonPhrase().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
