@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a task step.
 * @property baseImageDependencies List of base image dependencies for a step.
 * @property contextAccessToken The token (git PAT or SAS token of storage account blob) associated with the context for a step.
 * @property contextPath The URL(absolute or relative) of the source context for the task step.
 * @property taskFilePath The task template/definition file path relative to the source context.
 * @property type The type of the step.
 * Expected value is 'FileTask'.
 * @property values The collection of overridable values that can be passed when running a task.
 * @property valuesFilePath The task values/parameters file path relative to the source context.
 */
public data class FileTaskStepResponse(
    public val baseImageDependencies: List<BaseImageDependencyResponse>,
    public val contextAccessToken: String? = null,
    public val contextPath: String? = null,
    public val taskFilePath: String,
    public val type: String,
    public val values: List<SetValueResponse>? = null,
    public val valuesFilePath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.FileTaskStepResponse):
            FileTaskStepResponse = FileTaskStepResponse(
            baseImageDependencies = javaType.baseImageDependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.BaseImageDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            contextAccessToken = javaType.contextAccessToken().map({ args0 -> args0 }).orElse(null),
            contextPath = javaType.contextPath().map({ args0 -> args0 }).orElse(null),
            taskFilePath = javaType.taskFilePath(),
            type = javaType.type(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SetValueResponse.Companion.toKotlin(args0)
                })
            }),
            valuesFilePath = javaType.valuesFilePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
