@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents a cache rule for a container registry.
 * @property creationDate The creation date of the cache rule.
 * @property credentialSetResourceId The ARM resource ID of the credential store which is associated with the cache rule.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property provisioningState Provisioning state of the resource.
 * @property sourceRepository Source repository pulled from upstream.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property targetRepository Target repository specified in docker pull command.
 * Eg: docker pull myregistry.azurecr.io/{targetRepository}:{tag}
 * @property type The type of the resource.
 */
public data class GetCacheRuleResult(
    public val creationDate: String,
    public val credentialSetResourceId: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val sourceRepository: String? = null,
    public val systemData: SystemDataResponse,
    public val targetRepository: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetCacheRuleResult):
            GetCacheRuleResult = GetCacheRuleResult(
            creationDate = javaType.creationDate(),
            credentialSetResourceId = javaType.credentialSetResourceId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sourceRepository = javaType.sourceRepository().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetRepository = javaType.targetRepository().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
