@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An object that represents a connected registry for a container registry.
 * @property activation The activation properties of the connected registry.
 * @property clientTokenIds The list of the ACR token resource IDs used to authenticate clients to the connected registry.
 * @property connectionState The current connection state of the connected registry.
 * @property id The resource ID.
 * @property lastActivityTime The last activity time of the connected registry.
 * @property logging The logging properties of the connected registry.
 * @property loginServer The login server properties of the connected registry.
 * @property mode The mode of the connected registry resource that indicates the permissions of the registry.
 * @property name The name of the resource.
 * @property notificationsList The list of notifications subscription information for the connected registry.
 * @property parent The parent of the connected registry.
 * @property provisioningState Provisioning state of the resource.
 * @property statusDetails The list of current statuses of the connected registry.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 * @property version The current version of ACR runtime on the connected registry.
 */
public data class GetConnectedRegistryResult(
    public val activation: ActivationPropertiesResponse,
    public val clientTokenIds: List<String>? = null,
    public val connectionState: String,
    public val id: String,
    public val lastActivityTime: String,
    public val logging: LoggingPropertiesResponse? = null,
    public val loginServer: LoginServerPropertiesResponse? = null,
    public val mode: String,
    public val name: String,
    public val notificationsList: List<String>? = null,
    public val parent: ParentPropertiesResponse,
    public val provisioningState: String,
    public val statusDetails: List<StatusDetailPropertiesResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetConnectedRegistryResult):
            GetConnectedRegistryResult = GetConnectedRegistryResult(
            activation = javaType.activation().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.ActivationPropertiesResponse.Companion.toKotlin(args0)
            }),
            clientTokenIds = javaType.clientTokenIds().map({ args0 -> args0 }),
            connectionState = javaType.connectionState(),
            id = javaType.id(),
            lastActivityTime = javaType.lastActivityTime(),
            logging = javaType.logging().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.LoggingPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loginServer = javaType.loginServer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.LoginServerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mode = javaType.mode(),
            name = javaType.name(),
            notificationsList = javaType.notificationsList().map({ args0 -> args0 }),
            parent = javaType.parent().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.ParentPropertiesResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            statusDetails = javaType.statusDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusDetailPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
