@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents a pipeline run for a container registry.
 * @property forceUpdateTag How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property provisioningState The provisioning state of a pipeline run.
 * @property request The request parameters for a pipeline run.
 * @property response The response of a pipeline run.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetPipelineRunResult(
    public val forceUpdateTag: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val request: PipelineRunRequestResponse? = null,
    public val response: PipelineRunResponseResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetPipelineRunResult):
            GetPipelineRunResult = GetPipelineRunResult(
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            request = javaType.request().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunRequestResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            response = javaType.response().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunResponseResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
