@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the import pipeline source.
 * @property keyVaultUri They key vault secret uri to obtain the source storage SAS token.
 * @property type The type of source for the import pipeline.
 * @property uri The source uri of the import pipeline.
 * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
 * When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
 */
public data class ImportPipelineSourcePropertiesResponse(
    public val keyVaultUri: String,
    public val type: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ImportPipelineSourcePropertiesResponse):
            ImportPipelineSourcePropertiesResponse = ImportPipelineSourcePropertiesResponse(
            keyVaultUri = javaType.keyVaultUri(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
