@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status of an Azure resource at the time the operation was called.
 * @property displayStatus The short label for the status.
 * @property message The detailed message for the status, including alerts and error messages.
 * @property timestamp The timestamp when the status was changed to the current value.
 */
public data class StatusResponse(
    public val displayStatus: String,
    public val message: String,
    public val timestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.StatusResponse):
            StatusResponse = StatusResponse(
            displayStatus = javaType.displayStatus(),
            message = javaType.message(),
            timestamp = javaType.timestamp(),
        )
    }
}
