@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The TLS certificate properties of the connected registry login server.
 * @property location Indicates the location of the certificates.
 * @property type The type of certificate location.
 */
public data class TlsCertificatePropertiesResponse(
    public val location: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TlsCertificatePropertiesResponse):
            TlsCertificatePropertiesResponse = TlsCertificatePropertiesResponse(
            location = javaType.location(),
            type = javaType.type(),
        )
    }
}
