@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The password that will be used for authenticating the token of a container registry.
 * @property creationTime The creation datetime of the password.
 * @property expiry The expiry datetime of the password.
 * @property name The password name "password1" or "password2"
 * @property value The password value.
 */
public data class TokenPasswordResponse(
    public val creationTime: String? = null,
    public val expiry: String? = null,
    public val name: String? = null,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TokenPasswordResponse):
            TokenPasswordResponse = TokenPasswordResponse(
            creationTime = javaType.creationTime().map({ args0 -> args0 }).orElse(null),
            expiry = javaType.expiry().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
