@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.ManagedClusterArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.KubernetesSupportPlan
import com.pulumi.azurenative.containerservice.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceLinuxProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceLinuxProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceNetworkProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ContainerServiceNetworkProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAADProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAADProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAPIServerAccessProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAPIServerAccessProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAddonProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAddonProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAgentPoolProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAgentPoolProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAutoUpgradeProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAutoUpgradeProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAzureMonitorProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterAzureMonitorProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterHTTPProxyConfigArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterHTTPProxyConfigArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterIdentityArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterIdentityArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterOIDCIssuerProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterOIDCIssuerProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPodIdentityProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPodIdentityProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPropertiesAutoScalerProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterPropertiesAutoScalerProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSKUArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSKUArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSecurityProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterSecurityProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterServicePrincipalProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterServicePrincipalProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterStorageProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterStorageProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWindowsProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWindowsProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWorkloadAutoScalerProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.ManagedClusterWorkloadAutoScalerProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.PrivateLinkResourceArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.PrivateLinkResourceArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.UserAssignedIdentityArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.UserAssignedIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Managed cluster.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2017-08-31, 2019-02-01, 2019-06-01, 2021-05-01, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview, 2024-01-01, 2024-01-02-preview.
 * When creating a managed cluster you must define at least one agent pool inline via the `agentPoolProfiles` property. The Azure API does not currently allow this property to be updated directly. Instead, additional agent pools can be defined via the `AgentPool` resource. If needing to change the initial agent pool profile property, you can either trigger the whole cluster to be re-created by using the [replaceOnChanges resource option](https://www.pulumi.com/docs/concepts/options/replaceonchanges/), or make the change directly in Azure then use `pulumi refresh` to update the stack's stack to match.
 * ## Example Usage
 * ### Create Managed Cluster using an agent pool snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *                 {
 *                     SourceResourceId = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1",
 *                 },
 *                 EnableFIPS = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * CreationData: {
 * SourceResourceId: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
 * },
 * EnableFIPS: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(false),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("creationData", Map.of("sourceResourceId", "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1")),
 *                 Map.entry("enableFIPS", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with AKS-managed NAT gateway as outbound type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = false,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerSku = "standard",
 *             NatGatewayProfile = new AzureNative.ContainerService.Inputs.ManagedClusterNATGatewayProfileArgs
 *             {
 *                 ManagedOutboundIPProfile = new AzureNative.ContainerService.Inputs.ManagedClusterManagedOutboundIPProfileArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             OutboundType = "managedNATGateway",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(false),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerSku: pulumi.String("standard"),
 * NatGatewayProfile: interface{}{
 * ManagedOutboundIPProfile: &containerservice.ManagedClusterManagedOutboundIPProfileArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * OutboundType: pulumi.String("managedNATGateway"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", false),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("natGatewayProfile", Map.of("managedOutboundIPProfile", Map.of("count", 2))),
 *                 Map.entry("outboundType", "managedNATGateway")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Azure KeyVault Secrets Provider Addon
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles =
 *         {
 *             { "azureKeyvaultSecretsProvider", new AzureNative.ContainerService.Inputs.ManagedClusterAddonProfileArgs
 *             {
 *                 Config =
 *                 {
 *                     { "enableSecretRotation", "true" },
 *                     { "rotationPollInterval", "2m" },
 *                 },
 *                 Enabled = true,
 *             } },
 *         },
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: containerservice.ManagedClusterAddonProfileMap{
 * "azureKeyvaultSecretsProvider": &containerservice.ManagedClusterAddonProfileArgs{
 * Config: pulumi.StringMap{
 * "enableSecretRotation": pulumi.String("true"),
 * "rotationPollInterval": pulumi.String("2m"),
 * },
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles(Map.of("azureKeyvaultSecretsProvider", Map.ofEntries(
 *                 Map.entry("config", Map.ofEntries(
 *                     Map.entry("enableSecretRotation", "true"),
 *                     Map.entry("rotationPollInterval", "2m")
 *                 )),
 *                 Map.entry("enabled", true)
 *             )))
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Dedicated Host Group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 HostGroupID = "/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * HostGroupID: pulumi.String("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(false),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("hostGroupID", "/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with EncryptionAtHost enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with FIPS enabled OS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableFIPS = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = false,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableFIPS: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(false),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableFIPS", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(false)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with GPUMIG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 GpuInstanceProfile = "MIG3g",
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_ND96asr_v4",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * GpuInstanceProfile: pulumi.String("MIG3g"),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_ND96asr_v4"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * HttpProxy: pulumi.String("http://myproxy.server.com:8080"),
 * HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * NoProxy: pulumi.StringArray{
 * pulumi.String("localhost"),
 * pulumi.String("127.0.0.1"),
 * },
 * TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * },
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("gpuInstanceProfile", "MIG3g"),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_ND96asr_v4")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(Map.ofEntries(
 *                 Map.entry("httpProxy", "http://myproxy.server.com:8080"),
 *                 Map.entry("httpsProxy", "https://myproxy.server.com:8080"),
 *                 Map.entry("noProxy",
 *                     "localhost",
 *                     "127.0.0.1"),
 *                 Map.entry("trustedCa", "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *             ))
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with HTTP proxy configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * HttpProxy: pulumi.String("http://myproxy.server.com:8080"),
 * HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * NoProxy: pulumi.StringArray{
 * pulumi.String("localhost"),
 * pulumi.String("127.0.0.1"),
 * },
 * TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * },
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(Map.ofEntries(
 *                 Map.entry("httpProxy", "http://myproxy.server.com:8080"),
 *                 Map.entry("httpsProxy", "https://myproxy.server.com:8080"),
 *                 Map.entry("noProxy",
 *                     "localhost",
 *                     "127.0.0.1"),
 *                 Map.entry("trustedCa", "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *             ))
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with LongTermSupport
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             DisableRunCommand = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Base",
 *             Tier = "Premium",
 *         },
 *         SupportPlan = "AKSLongTermSupport",
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * DisableRunCommand: pulumi.Bool(true),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Base"),
 * Tier: pulumi.String("Premium"),
 * },
 * SupportPlan: pulumi.String("AKSLongTermSupport"),
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.of("disableRunCommand", true))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Base"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .supportPlan("AKSLongTermSupport")
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Node Public IP Prefix
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 NodePublicIPPrefixID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * NodePublicIPPrefixID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("nodePublicIPPrefixID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/publicIPPrefixes/public-ip-prefix"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with OSSKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsSKU = "AzureLinux",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         HttpProxyConfig = new AzureNative.ContainerService.Inputs.ManagedClusterHTTPProxyConfigArgs
 *         {
 *             HttpProxy = "http://myproxy.server.com:8080",
 *             HttpsProxy = "https://myproxy.server.com:8080",
 *             NoProxy = new[]
 *             {
 *                 "localhost",
 *                 "127.0.0.1",
 *             },
 *             TrustedCa = "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=",
 *         },
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsSKU: pulumi.String("AzureLinux"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * HttpProxyConfig: &containerservice.ManagedClusterHTTPProxyConfigArgs{
 * HttpProxy: pulumi.String("http://myproxy.server.com:8080"),
 * HttpsProxy: pulumi.String("https://myproxy.server.com:8080"),
 * NoProxy: pulumi.StringArray{
 * pulumi.String("localhost"),
 * pulumi.String("127.0.0.1"),
 * },
 * TrustedCa: pulumi.String("Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U="),
 * },
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osSKU", "AzureLinux"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .httpProxyConfig(Map.ofEntries(
 *                 Map.entry("httpProxy", "http://myproxy.server.com:8080"),
 *                 Map.entry("httpsProxy", "https://myproxy.server.com:8080"),
 *                 Map.entry("noProxy",
 *                     "localhost",
 *                     "127.0.0.1"),
 *                 Map.entry("trustedCa", "Q29uZ3JhdHMhIFlvdSBoYXZlIGZvdW5kIGEgaGlkZGVuIG1lc3NhZ2U=")
 *             ))
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with PPG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 ProximityPlacementGroupID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * ProximityPlacementGroupID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("proximityPlacementGroupID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with PodIdentity enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         PodIdentityProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPodIdentityProfileArgs
 *         {
 *             AllowNetworkPluginKubenet = true,
 *             Enabled = true,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * PodIdentityProfile: &containerservice.ManagedClusterPodIdentityProfileArgs{
 * AllowNetworkPluginKubenet: pulumi.Bool(true),
 * Enabled: pulumi.Bool(true),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .podIdentityProfile(Map.ofEntries(
 *                 Map.entry("allowNetworkPluginKubenet", true),
 *                 Map.entry("enabled", true)
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with RunCommand disabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             DisableRunCommand = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * DisableRunCommand: pulumi.Bool(true),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.of("disableRunCommand", true))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with Security Profile configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         SecurityProfile = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileArgs
 *         {
 *             Defender = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileDefenderArgs
 *             {
 *                 LogAnalyticsWorkspaceResourceId = "/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME",
 *                 SecurityMonitoring = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *             WorkloadIdentity = new AzureNative.ContainerService.Inputs.ManagedClusterSecurityProfileWorkloadIdentityArgs
 *             {
 *                 Enabled = true,
 *             },
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * SecurityProfile: containerservice.ManagedClusterSecurityProfileResponse{
 * Defender: interface{}{
 * LogAnalyticsWorkspaceResourceId: pulumi.String("/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
 * SecurityMonitoring: &containerservice.ManagedClusterSecurityProfileDefenderSecurityMonitoringArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * WorkloadIdentity: &containerservice.ManagedClusterSecurityProfileWorkloadIdentityArgs{
 * Enabled: pulumi.Bool(true),
 * },
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .securityProfile(Map.ofEntries(
 *                 Map.entry("defender", Map.ofEntries(
 *                     Map.entry("logAnalyticsWorkspaceResourceId", "/subscriptions/SUB_ID/resourcegroups/RG_NAME/providers/microsoft.operationalinsights/workspaces/WORKSPACE_NAME"),
 *                     Map.entry("securityMonitoring", Map.of("enabled", true))
 *                 )),
 *                 Map.entry("workloadIdentity", Map.of("enabled", true))
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with UltraSSD enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 EnableUltraSSD = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * EnableUltraSSD: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("enableUltraSSD", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Cluster with user-assigned NAT gateway as outbound type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableNodePublicIP = false,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerSku = "standard",
 *             OutboundType = "userAssignedNATGateway",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(false),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: &containerservice.ContainerServiceNetworkProfileArgs{
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("userAssignedNATGateway"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", false),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "userAssignedNATGateway")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Private Cluster with Public FQDN specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             EnablePrivateCluster = true,
 *             EnablePrivateClusterPublicFQDN = true,
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * EnablePrivateCluster: pulumi.Bool(true),
 * EnablePrivateClusterPublicFQDN: pulumi.Bool(true),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.ofEntries(
 *                 Map.entry("enablePrivateCluster", true),
 *                 Map.entry("enablePrivateClusterPublicFQDN", true)
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Managed Private Cluster with fqdn subdomain specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 EnableEncryptionAtHost = true,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS2_v2",
 *             },
 *         },
 *         ApiServerAccessProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAPIServerAccessProfileArgs
 *         {
 *             EnablePrivateCluster = true,
 *             PrivateDNSZone = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io",
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         FqdnSubdomain = "domain1",
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * Count: pulumi.Int(3),
 * EnableEncryptionAtHost: pulumi.Bool(true),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS2_v2"),
 * },
 * },
 * ApiServerAccessProfile: &containerservice.ManagedClusterAPIServerAccessProfileArgs{
 * EnablePrivateCluster: pulumi.Bool(true),
 * PrivateDNSZone: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io"),
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * FqdnSubdomain: pulumi.String("domain1"),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("count", 3),
 *                 Map.entry("enableEncryptionAtHost", true),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS2_v2")
 *             ))
 *             .apiServerAccessProfile(Map.ofEntries(
 *                 Map.entry("enablePrivateCluster", true),
 *                 Map.entry("privateDNSZone", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Network/privateDnsZones/privatelink.location1.azmk8s.io")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .fqdnSubdomain("domain1")
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create/Update AAD Managed Cluster with EnableAzureRBAC
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedCluster = new AzureNative.ContainerService.ManagedCluster("managedCluster", new()
 *     {
 *         AadProfile = new AzureNative.ContainerService.Inputs.ManagedClusterAADProfileArgs
 *         {
 *             EnableAzureRBAC = true,
 *             Managed = true,
 *         },
 *         AddonProfiles = null,
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.ManagedClusterAgentPoolProfileArgs
 *             {
 *                 AvailabilityZones = new[]
 *                 {
 *                     "1",
 *                     "2",
 *                     "3",
 *                 },
 *                 Count = 3,
 *                 EnableNodePublicIP = true,
 *                 Mode = "System",
 *                 Name = "nodepool1",
 *                 OsType = "Linux",
 *                 Type = "VirtualMachineScaleSets",
 *                 VmSize = "Standard_DS1_v2",
 *             },
 *         },
 *         AutoScalerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterPropertiesAutoScalerProfileArgs
 *         {
 *             ScaleDownDelayAfterAdd = "15m",
 *             ScanInterval = "20s",
 *         },
 *         DiskEncryptionSetID = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des",
 *         DnsPrefix = "dnsprefix1",
 *         EnablePodSecurityPolicy = true,
 *         EnableRBAC = true,
 *         KubernetesVersion = "",
 *         LinuxProfile = new AzureNative.ContainerService.Inputs.ContainerServiceLinuxProfileArgs
 *         {
 *             AdminUsername = "azureuser",
 *             Ssh = new AzureNative.ContainerService.Inputs.ContainerServiceSshConfigurationArgs
 *             {
 *                 PublicKeys = new[]
 *                 {
 *                     new AzureNative.ContainerService.Inputs.ContainerServiceSshPublicKeyArgs
 *                     {
 *                         KeyData = "keydata",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.ContainerServiceNetworkProfileArgs
 *         {
 *             LoadBalancerProfile = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileArgs
 *             {
 *                 ManagedOutboundIPs = new AzureNative.ContainerService.Inputs.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs
 *                 {
 *                     Count = 2,
 *                 },
 *             },
 *             LoadBalancerSku = "standard",
 *             OutboundType = "loadBalancer",
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ServicePrincipalProfile = new AzureNative.ContainerService.Inputs.ManagedClusterServicePrincipalProfileArgs
 *         {
 *             ClientId = "clientid",
 *             Secret = "secret",
 *         },
 *         Sku = new AzureNative.ContainerService.Inputs.ManagedClusterSKUArgs
 *         {
 *             Name = "Basic",
 *             Tier = "Free",
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *         WindowsProfile = new AzureNative.ContainerService.Inputs.ManagedClusterWindowsProfileArgs
 *         {
 *             AdminPassword = "replacePassword1234$",
 *             AdminUsername = "azureuser",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := containerservice.NewManagedCluster(ctx, "managedCluster", &containerservice.ManagedClusterArgs{
 * AadProfile: &containerservice.ManagedClusterAADProfileArgs{
 * EnableAzureRBAC: pulumi.Bool(true),
 * Managed: pulumi.Bool(true),
 * },
 * AddonProfiles: nil,
 * AgentPoolProfiles: []containerservice.ManagedClusterAgentPoolProfileArgs{
 * {
 * AvailabilityZones: pulumi.StringArray{
 * pulumi.String("1"),
 * pulumi.String("2"),
 * pulumi.String("3"),
 * },
 * Count: pulumi.Int(3),
 * EnableNodePublicIP: pulumi.Bool(true),
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("nodepool1"),
 * OsType: pulumi.String("Linux"),
 * Type: pulumi.String("VirtualMachineScaleSets"),
 * VmSize: pulumi.String("Standard_DS1_v2"),
 * },
 * },
 * AutoScalerProfile: &containerservice.ManagedClusterPropertiesAutoScalerProfileArgs{
 * ScaleDownDelayAfterAdd: pulumi.String("15m"),
 * ScanInterval: pulumi.String("20s"),
 * },
 * DiskEncryptionSetID: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des"),
 * DnsPrefix: pulumi.String("dnsprefix1"),
 * EnablePodSecurityPolicy: pulumi.Bool(true),
 * EnableRBAC: pulumi.Bool(true),
 * KubernetesVersion: pulumi.String(""),
 * LinuxProfile: containerservice.ContainerServiceLinuxProfileResponse{
 * AdminUsername: pulumi.String("azureuser"),
 * Ssh: interface{}{
 * PublicKeys: containerservice.ContainerServiceSshPublicKeyArray{
 * &containerservice.ContainerServiceSshPublicKeyArgs{
 * KeyData: pulumi.String("keydata"),
 * },
 * },
 * },
 * },
 * Location: pulumi.String("location1"),
 * NetworkProfile: containerservice.ContainerServiceNetworkProfileResponse{
 * LoadBalancerProfile: interface{}{
 * ManagedOutboundIPs: &containerservice.ManagedClusterLoadBalancerProfileManagedOutboundIPsArgs{
 * Count: pulumi.Int(2),
 * },
 * },
 * LoadBalancerSku: pulumi.String("standard"),
 * OutboundType: pulumi.String("loadBalancer"),
 * },
 * ResourceGroupName: pulumi.String("rg1"),
 * ResourceName: pulumi.String("clustername1"),
 * ServicePrincipalProfile: &containerservice.ManagedClusterServicePrincipalProfileArgs{
 * ClientId: pulumi.String("clientid"),
 * Secret: pulumi.String("secret"),
 * },
 * Sku: &containerservice.ManagedClusterSKUArgs{
 * Name: pulumi.String("Basic"),
 * Tier: pulumi.String("Free"),
 * },
 * Tags: pulumi.StringMap{
 * "archv2": pulumi.String(""),
 * "tier": pulumi.String("production"),
 * },
 * WindowsProfile: &containerservice.ManagedClusterWindowsProfileArgs{
 * AdminPassword: pulumi.String("replacePassword1234$"),
 * AdminUsername: pulumi.String("azureuser"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedCluster;
 * import com.pulumi.azurenative.containerservice.ManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedCluster = new ManagedCluster("managedCluster", ManagedClusterArgs.builder()
 *             .aadProfile(Map.ofEntries(
 *                 Map.entry("enableAzureRBAC", true),
 *                 Map.entry("managed", true)
 *             ))
 *             .addonProfiles()
 *             .agentPoolProfiles(Map.ofEntries(
 *                 Map.entry("availabilityZones",
 *                     "1",
 *                     "2",
 *                     "3"),
 *                 Map.entry("count", 3),
 *                 Map.entry("enableNodePublicIP", true),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "nodepool1"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("type", "VirtualMachineScaleSets"),
 *                 Map.entry("vmSize", "Standard_DS1_v2")
 *             ))
 *             .autoScalerProfile(Map.ofEntries(
 *                 Map.entry("scaleDownDelayAfterAdd", "15m"),
 *                 Map.entry("scanInterval", "20s")
 *             ))
 *             .diskEncryptionSetID("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.Compute/diskEncryptionSets/des")
 *             .dnsPrefix("dnsprefix1")
 *             .enablePodSecurityPolicy(true)
 *             .enableRBAC(true)
 *             .kubernetesVersion("")
 *             .linuxProfile(Map.ofEntries(
 *                 Map.entry("adminUsername", "azureuser"),
 *                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "keydata")))
 *             ))
 *             .location("location1")
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("loadBalancerProfile", Map.of("managedOutboundIPs", Map.of("count", 2))),
 *                 Map.entry("loadBalancerSku", "standard"),
 *                 Map.entry("outboundType", "loadBalancer")
 *             ))
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .servicePrincipalProfile(Map.ofEntries(
 *                 Map.entry("clientId", "clientid"),
 *                 Map.entry("secret", "secret")
 *             ))
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Basic"),
 *                 Map.entry("tier", "Free")
 *             ))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .windowsProfile(Map.ofEntries(
 *                 Map.entry("adminPassword", "replacePassword1234$"),
 *                 Map.entry("adminUsername", "azureuser")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:ManagedCluster clustername1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}
 * ```
 * @property aadProfile The Azure Active Directory configuration.
 * @property addonProfiles The profile of managed cluster add-on.
 * @property agentPoolProfiles The agent pool properties.
 * @property apiServerAccessProfile The access profile for managed cluster API server.
 * @property autoScalerProfile Parameters to be applied to the cluster-autoscaler when enabled
 * @property autoUpgradeProfile The auto upgrade configuration.
 * @property azureMonitorProfile Azure Monitor addon profiles for monitoring the managed cluster.
 * @property disableLocalAccounts If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
 * @property diskEncryptionSetID This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
 * @property dnsPrefix This cannot be updated once the Managed Cluster has been created.
 * @property enablePodSecurityPolicy (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
 * @property enableRBAC Whether to enable Kubernetes Role-Based Access Control.
 * @property extendedLocation The extended location of the Virtual Machine.
 * @property fqdnSubdomain This cannot be updated once the Managed Cluster has been created.
 * @property httpProxyConfig Configurations for provisioning the cluster with HTTP proxy servers.
 * @property identity The identity of the managed cluster, if configured.
 * @property identityProfile Identities associated with the cluster.
 * @property kubernetesVersion Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
 * @property linuxProfile The profile for Linux VMs in the Managed Cluster.
 * @property location The geo-location where the resource lives
 * @property networkProfile The network configuration profile.
 * @property nodeResourceGroup The name of the resource group containing agent pool nodes.
 * @property oidcIssuerProfile The OIDC issuer profile of the Managed Cluster.
 * @property podIdentityProfile See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
 * @property privateLinkResources Private link resources associated with the cluster.
 * @property publicNetworkAccess Allow or deny public network access for AKS
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property securityProfile Security profile for the managed cluster.
 * @property servicePrincipalProfile Information about a service principal identity for the cluster to use for manipulating Azure APIs.
 * @property sku The managed cluster SKU.
 * @property storageProfile Storage profile for the managed cluster.
 * @property supportPlan The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
 * @property tags Resource tags.
 * @property windowsProfile The profile for Windows VMs in the Managed Cluster.
 * @property workloadAutoScalerProfile Workload Auto-scaler profile for the managed cluster.
 */
public data class ManagedClusterArgs(
    public val aadProfile: Output<ManagedClusterAADProfileArgs>? = null,
    public val addonProfiles: Output<Map<String, ManagedClusterAddonProfileArgs>>? = null,
    public val agentPoolProfiles: Output<List<ManagedClusterAgentPoolProfileArgs>>? = null,
    public val apiServerAccessProfile: Output<ManagedClusterAPIServerAccessProfileArgs>? = null,
    public val autoScalerProfile: Output<ManagedClusterPropertiesAutoScalerProfileArgs>? = null,
    public val autoUpgradeProfile: Output<ManagedClusterAutoUpgradeProfileArgs>? = null,
    public val azureMonitorProfile: Output<ManagedClusterAzureMonitorProfileArgs>? = null,
    public val disableLocalAccounts: Output<Boolean>? = null,
    public val diskEncryptionSetID: Output<String>? = null,
    public val dnsPrefix: Output<String>? = null,
    public val enablePodSecurityPolicy: Output<Boolean>? = null,
    public val enableRBAC: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val fqdnSubdomain: Output<String>? = null,
    public val httpProxyConfig: Output<ManagedClusterHTTPProxyConfigArgs>? = null,
    public val identity: Output<ManagedClusterIdentityArgs>? = null,
    public val identityProfile: Output<Map<String, UserAssignedIdentityArgs>>? = null,
    public val kubernetesVersion: Output<String>? = null,
    public val linuxProfile: Output<ContainerServiceLinuxProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val networkProfile: Output<ContainerServiceNetworkProfileArgs>? = null,
    public val nodeResourceGroup: Output<String>? = null,
    public val oidcIssuerProfile: Output<ManagedClusterOIDCIssuerProfileArgs>? = null,
    public val podIdentityProfile: Output<ManagedClusterPodIdentityProfileArgs>? = null,
    public val privateLinkResources: Output<List<PrivateLinkResourceArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val securityProfile: Output<ManagedClusterSecurityProfileArgs>? = null,
    public val servicePrincipalProfile: Output<ManagedClusterServicePrincipalProfileArgs>? = null,
    public val sku: Output<ManagedClusterSKUArgs>? = null,
    public val storageProfile: Output<ManagedClusterStorageProfileArgs>? = null,
    public val supportPlan: Output<Either<String, KubernetesSupportPlan>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val windowsProfile: Output<ManagedClusterWindowsProfileArgs>? = null,
    public val workloadAutoScalerProfile: Output<ManagedClusterWorkloadAutoScalerProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.ManagedClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.ManagedClusterArgs =
        com.pulumi.azurenative.containerservice.ManagedClusterArgs.builder()
            .aadProfile(aadProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .addonProfiles(
                addonProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .agentPoolProfiles(
                agentPoolProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .apiServerAccessProfile(
                apiServerAccessProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoScalerProfile(autoScalerProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoUpgradeProfile(
                autoUpgradeProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .azureMonitorProfile(
                azureMonitorProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .disableLocalAccounts(disableLocalAccounts?.applyValue({ args0 -> args0 }))
            .diskEncryptionSetID(diskEncryptionSetID?.applyValue({ args0 -> args0 }))
            .dnsPrefix(dnsPrefix?.applyValue({ args0 -> args0 }))
            .enablePodSecurityPolicy(enablePodSecurityPolicy?.applyValue({ args0 -> args0 }))
            .enableRBAC(enableRBAC?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fqdnSubdomain(fqdnSubdomain?.applyValue({ args0 -> args0 }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identityProfile(
                identityProfile?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .kubernetesVersion(kubernetesVersion?.applyValue({ args0 -> args0 }))
            .linuxProfile(linuxProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeResourceGroup(nodeResourceGroup?.applyValue({ args0 -> args0 }))
            .oidcIssuerProfile(oidcIssuerProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .podIdentityProfile(
                podIdentityProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .privateLinkResources(
                privateLinkResources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .securityProfile(securityProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .servicePrincipalProfile(
                servicePrincipalProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .supportPlan(
                supportPlan?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .windowsProfile(windowsProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .workloadAutoScalerProfile(
                workloadAutoScalerProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterArgs].
 */
@PulumiTagMarker
public class ManagedClusterArgsBuilder internal constructor() {
    private var aadProfile: Output<ManagedClusterAADProfileArgs>? = null

    private var addonProfiles: Output<Map<String, ManagedClusterAddonProfileArgs>>? = null

    private var agentPoolProfiles: Output<List<ManagedClusterAgentPoolProfileArgs>>? = null

    private var apiServerAccessProfile: Output<ManagedClusterAPIServerAccessProfileArgs>? = null

    private var autoScalerProfile: Output<ManagedClusterPropertiesAutoScalerProfileArgs>? = null

    private var autoUpgradeProfile: Output<ManagedClusterAutoUpgradeProfileArgs>? = null

    private var azureMonitorProfile: Output<ManagedClusterAzureMonitorProfileArgs>? = null

    private var disableLocalAccounts: Output<Boolean>? = null

    private var diskEncryptionSetID: Output<String>? = null

    private var dnsPrefix: Output<String>? = null

    private var enablePodSecurityPolicy: Output<Boolean>? = null

    private var enableRBAC: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var fqdnSubdomain: Output<String>? = null

    private var httpProxyConfig: Output<ManagedClusterHTTPProxyConfigArgs>? = null

    private var identity: Output<ManagedClusterIdentityArgs>? = null

    private var identityProfile: Output<Map<String, UserAssignedIdentityArgs>>? = null

    private var kubernetesVersion: Output<String>? = null

    private var linuxProfile: Output<ContainerServiceLinuxProfileArgs>? = null

    private var location: Output<String>? = null

    private var networkProfile: Output<ContainerServiceNetworkProfileArgs>? = null

    private var nodeResourceGroup: Output<String>? = null

    private var oidcIssuerProfile: Output<ManagedClusterOIDCIssuerProfileArgs>? = null

    private var podIdentityProfile: Output<ManagedClusterPodIdentityProfileArgs>? = null

    private var privateLinkResources: Output<List<PrivateLinkResourceArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var securityProfile: Output<ManagedClusterSecurityProfileArgs>? = null

    private var servicePrincipalProfile: Output<ManagedClusterServicePrincipalProfileArgs>? = null

    private var sku: Output<ManagedClusterSKUArgs>? = null

    private var storageProfile: Output<ManagedClusterStorageProfileArgs>? = null

    private var supportPlan: Output<Either<String, KubernetesSupportPlan>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var windowsProfile: Output<ManagedClusterWindowsProfileArgs>? = null

    private var workloadAutoScalerProfile: Output<ManagedClusterWorkloadAutoScalerProfileArgs>? = null

    /**
     * @param value The Azure Active Directory configuration.
     */
    @JvmName("scjdrdgofsdvoyft")
    public suspend fun aadProfile(`value`: Output<ManagedClusterAADProfileArgs>) {
        this.aadProfile = value
    }

    /**
     * @param value The profile of managed cluster add-on.
     */
    @JvmName("aymqpckkvsmrbtly")
    public suspend fun addonProfiles(`value`: Output<Map<String, ManagedClusterAddonProfileArgs>>) {
        this.addonProfiles = value
    }

    /**
     * @param value The agent pool properties.
     */
    @JvmName("pkkyamwrpkpnndsn")
    public suspend fun agentPoolProfiles(`value`: Output<List<ManagedClusterAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = value
    }

    @JvmName("vhwdjufdhswdoali")
    public suspend fun agentPoolProfiles(vararg values: Output<ManagedClusterAgentPoolProfileArgs>) {
        this.agentPoolProfiles = Output.all(values.asList())
    }

    /**
     * @param values The agent pool properties.
     */
    @JvmName("ynsdlpfqtojglbvo")
    public suspend fun agentPoolProfiles(values: List<Output<ManagedClusterAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = Output.all(values)
    }

    /**
     * @param value The access profile for managed cluster API server.
     */
    @JvmName("dvlgsdvtckpvagxw")
    public suspend
    fun apiServerAccessProfile(`value`: Output<ManagedClusterAPIServerAccessProfileArgs>) {
        this.apiServerAccessProfile = value
    }

    /**
     * @param value Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JvmName("xkwyqtcugvjmuwoe")
    public suspend
    fun autoScalerProfile(`value`: Output<ManagedClusterPropertiesAutoScalerProfileArgs>) {
        this.autoScalerProfile = value
    }

    /**
     * @param value The auto upgrade configuration.
     */
    @JvmName("sqybjujterkdbjil")
    public suspend fun autoUpgradeProfile(`value`: Output<ManagedClusterAutoUpgradeProfileArgs>) {
        this.autoUpgradeProfile = value
    }

    /**
     * @param value Azure Monitor addon profiles for monitoring the managed cluster.
     */
    @JvmName("cwwqnbdfscmjyecm")
    public suspend fun azureMonitorProfile(`value`: Output<ManagedClusterAzureMonitorProfileArgs>) {
        this.azureMonitorProfile = value
    }

    /**
     * @param value If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     */
    @JvmName("jkamevkgojwptrlc")
    public suspend fun disableLocalAccounts(`value`: Output<Boolean>) {
        this.disableLocalAccounts = value
    }

    /**
     * @param value This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
     */
    @JvmName("iwmgcioolluwjvsg")
    public suspend fun diskEncryptionSetID(`value`: Output<String>) {
        this.diskEncryptionSetID = value
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("pyaqapovjygdrifa")
    public suspend fun dnsPrefix(`value`: Output<String>) {
        this.dnsPrefix = value
    }

    /**
     * @param value (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
     */
    @JvmName("ejgemuoutmxskliq")
    public suspend fun enablePodSecurityPolicy(`value`: Output<Boolean>) {
        this.enablePodSecurityPolicy = value
    }

    /**
     * @param value Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("yqdirewaymssbmhr")
    public suspend fun enableRBAC(`value`: Output<Boolean>) {
        this.enableRBAC = value
    }

    /**
     * @param value The extended location of the Virtual Machine.
     */
    @JvmName("rtuisknspvxsdwkv")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("borqojypddpeuiat")
    public suspend fun fqdnSubdomain(`value`: Output<String>) {
        this.fqdnSubdomain = value
    }

    /**
     * @param value Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("tbwtflpgdktwytyg")
    public suspend fun httpProxyConfig(`value`: Output<ManagedClusterHTTPProxyConfigArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value The identity of the managed cluster, if configured.
     */
    @JvmName("gvherkutkkwmduns")
    public suspend fun identity(`value`: Output<ManagedClusterIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Identities associated with the cluster.
     */
    @JvmName("nqhdgaqiicifoqak")
    public suspend fun identityProfile(`value`: Output<Map<String, UserAssignedIdentityArgs>>) {
        this.identityProfile = value
    }

    /**
     * @param value Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     */
    @JvmName("shxhhdlwuhmmuvvi")
    public suspend fun kubernetesVersion(`value`: Output<String>) {
        this.kubernetesVersion = value
    }

    /**
     * @param value The profile for Linux VMs in the Managed Cluster.
     */
    @JvmName("eetgskdglxuqgqvl")
    public suspend fun linuxProfile(`value`: Output<ContainerServiceLinuxProfileArgs>) {
        this.linuxProfile = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uwhqmewnapdlguhu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The network configuration profile.
     */
    @JvmName("gnhygtsxtyoeuxyv")
    public suspend fun networkProfile(`value`: Output<ContainerServiceNetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The name of the resource group containing agent pool nodes.
     */
    @JvmName("ombhnjgrfhkxbalb")
    public suspend fun nodeResourceGroup(`value`: Output<String>) {
        this.nodeResourceGroup = value
    }

    /**
     * @param value The OIDC issuer profile of the Managed Cluster.
     */
    @JvmName("agxtnirvrpqywhal")
    public suspend fun oidcIssuerProfile(`value`: Output<ManagedClusterOIDCIssuerProfileArgs>) {
        this.oidcIssuerProfile = value
    }

    /**
     * @param value See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
     */
    @JvmName("wvbyxmghlyrrlakp")
    public suspend fun podIdentityProfile(`value`: Output<ManagedClusterPodIdentityProfileArgs>) {
        this.podIdentityProfile = value
    }

    /**
     * @param value Private link resources associated with the cluster.
     */
    @JvmName("wyoffrkehaclcjfo")
    public suspend fun privateLinkResources(`value`: Output<List<PrivateLinkResourceArgs>>) {
        this.privateLinkResources = value
    }

    @JvmName("vvxfpyowsnuhdalt")
    public suspend fun privateLinkResources(vararg values: Output<PrivateLinkResourceArgs>) {
        this.privateLinkResources = Output.all(values.asList())
    }

    /**
     * @param values Private link resources associated with the cluster.
     */
    @JvmName("sqborpinqljldpiq")
    public suspend fun privateLinkResources(values: List<Output<PrivateLinkResourceArgs>>) {
        this.privateLinkResources = Output.all(values)
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("nxsgtfrwlbidywsw")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yrtbtptnujdlikqp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("ttpakdmxnxckapqr")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Security profile for the managed cluster.
     */
    @JvmName("qddtftofaanulsdj")
    public suspend fun securityProfile(`value`: Output<ManagedClusterSecurityProfileArgs>) {
        this.securityProfile = value
    }

    /**
     * @param value Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    @JvmName("mtorrvulvycgcxiw")
    public suspend
    fun servicePrincipalProfile(`value`: Output<ManagedClusterServicePrincipalProfileArgs>) {
        this.servicePrincipalProfile = value
    }

    /**
     * @param value The managed cluster SKU.
     */
    @JvmName("vfkxtdaprplcwqhv")
    public suspend fun sku(`value`: Output<ManagedClusterSKUArgs>) {
        this.sku = value
    }

    /**
     * @param value Storage profile for the managed cluster.
     */
    @JvmName("mumsuinokfbkchrb")
    public suspend fun storageProfile(`value`: Output<ManagedClusterStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("rsscrnqlabiqqqdh")
    public suspend fun supportPlan(`value`: Output<Either<String, KubernetesSupportPlan>>) {
        this.supportPlan = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dghlomuoiyhtebmq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The profile for Windows VMs in the Managed Cluster.
     */
    @JvmName("guidlcwqbsxdgbro")
    public suspend fun windowsProfile(`value`: Output<ManagedClusterWindowsProfileArgs>) {
        this.windowsProfile = value
    }

    /**
     * @param value Workload Auto-scaler profile for the managed cluster.
     */
    @JvmName("ogyetbeicxsmxohe")
    public suspend
    fun workloadAutoScalerProfile(`value`: Output<ManagedClusterWorkloadAutoScalerProfileArgs>) {
        this.workloadAutoScalerProfile = value
    }

    /**
     * @param value The Azure Active Directory configuration.
     */
    @JvmName("frbnyfretwvstsat")
    public suspend fun aadProfile(`value`: ManagedClusterAADProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadProfile = mapped
    }

    /**
     * @param argument The Azure Active Directory configuration.
     */
    @JvmName("aspqylbsnthdtsbk")
    public suspend fun aadProfile(argument: suspend ManagedClusterAADProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAADProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadProfile = mapped
    }

    /**
     * @param value The profile of managed cluster add-on.
     */
    @JvmName("sivkmpaboermqimq")
    public suspend fun addonProfiles(`value`: Map<String, ManagedClusterAddonProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param argument The profile of managed cluster add-on.
     */
    @JvmName("wqsstrhwmrijcglt")
    public suspend fun addonProfiles(
        vararg
        argument: Pair<String, suspend ManagedClusterAddonProfileArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ManagedClusterAddonProfileArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.addonProfiles = mapped
    }

    /**
     * @param values The profile of managed cluster add-on.
     */
    @JvmName("brhckaumjxsqdhiv")
    public fun addonProfiles(vararg values: Pair<String, ManagedClusterAddonProfileArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addonProfiles = mapped
    }

    /**
     * @param value The agent pool properties.
     */
    @JvmName("txtclhvrdhvifgfa")
    public suspend fun agentPoolProfiles(`value`: List<ManagedClusterAgentPoolProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pool properties.
     */
    @JvmName("klrowmqjknvelrav")
    public suspend
    fun agentPoolProfiles(argument: List<suspend ManagedClusterAgentPoolProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedClusterAgentPoolProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pool properties.
     */
    @JvmName("doseftbdwuyplsio")
    public suspend fun agentPoolProfiles(
        vararg
        argument: suspend ManagedClusterAgentPoolProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ManagedClusterAgentPoolProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument The agent pool properties.
     */
    @JvmName("xygewubrinndmdeo")
    public suspend
    fun agentPoolProfiles(argument: suspend ManagedClusterAgentPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedClusterAgentPoolProfileArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param values The agent pool properties.
     */
    @JvmName("jkhvdaoxsfwqhsfl")
    public suspend fun agentPoolProfiles(vararg values: ManagedClusterAgentPoolProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param value The access profile for managed cluster API server.
     */
    @JvmName("nugsfstduuegbrvj")
    public suspend fun apiServerAccessProfile(`value`: ManagedClusterAPIServerAccessProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiServerAccessProfile = mapped
    }

    /**
     * @param argument The access profile for managed cluster API server.
     */
    @JvmName("ksiafeteekokuyrt")
    public suspend
    fun apiServerAccessProfile(argument: suspend ManagedClusterAPIServerAccessProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAPIServerAccessProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.apiServerAccessProfile = mapped
    }

    /**
     * @param value Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JvmName("ogqqgqgdryrxfxgy")
    public suspend fun autoScalerProfile(`value`: ManagedClusterPropertiesAutoScalerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalerProfile = mapped
    }

    /**
     * @param argument Parameters to be applied to the cluster-autoscaler when enabled
     */
    @JvmName("ppcdvblorwsbpakl")
    public suspend
    fun autoScalerProfile(argument: suspend ManagedClusterPropertiesAutoScalerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterPropertiesAutoScalerProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScalerProfile = mapped
    }

    /**
     * @param value The auto upgrade configuration.
     */
    @JvmName("jotkrspjattnwjsm")
    public suspend fun autoUpgradeProfile(`value`: ManagedClusterAutoUpgradeProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeProfile = mapped
    }

    /**
     * @param argument The auto upgrade configuration.
     */
    @JvmName("lyxrbtmdedaifief")
    public suspend
    fun autoUpgradeProfile(argument: suspend ManagedClusterAutoUpgradeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAutoUpgradeProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoUpgradeProfile = mapped
    }

    /**
     * @param value Azure Monitor addon profiles for monitoring the managed cluster.
     */
    @JvmName("pfwymlubyxxyghdl")
    public suspend fun azureMonitorProfile(`value`: ManagedClusterAzureMonitorProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorProfile = mapped
    }

    /**
     * @param argument Azure Monitor addon profiles for monitoring the managed cluster.
     */
    @JvmName("ayxfskdfrapwtgqi")
    public suspend
    fun azureMonitorProfile(argument: suspend ManagedClusterAzureMonitorProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterAzureMonitorProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.azureMonitorProfile = mapped
    }

    /**
     * @param value If set to true, getting static credentials will be disabled for this cluster. This must only be used on Managed Clusters that are AAD enabled. For more details see [disable local accounts](https://docs.microsoft.com/azure/aks/managed-aad#disable-local-accounts-preview).
     */
    @JvmName("radfctgyxyxybeio")
    public suspend fun disableLocalAccounts(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAccounts = mapped
    }

    /**
     * @param value This is of the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/diskEncryptionSets/{encryptionSetName}'
     */
    @JvmName("pubmimsjlcrypsej")
    public suspend fun diskEncryptionSetID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetID = mapped
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("agmpdupjhekcgpje")
    public suspend fun dnsPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsPrefix = mapped
    }

    /**
     * @param value (DEPRECATED) Whether to enable Kubernetes pod security policy (preview). PodSecurityPolicy was deprecated in Kubernetes v1.21, and removed from Kubernetes in v1.25. Learn more at https://aka.ms/k8s/psp and https://aka.ms/aks/psp.
     */
    @JvmName("frrdgxbfutnfehqc")
    public suspend fun enablePodSecurityPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePodSecurityPolicy = mapped
    }

    /**
     * @param value Whether to enable Kubernetes Role-Based Access Control.
     */
    @JvmName("jwxnnlgeteuaxjek")
    public suspend fun enableRBAC(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRBAC = mapped
    }

    /**
     * @param value The extended location of the Virtual Machine.
     */
    @JvmName("svwrmhhtlyxbrikt")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the Virtual Machine.
     */
    @JvmName("ebcnmmrxjnkvsgxw")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value This cannot be updated once the Managed Cluster has been created.
     */
    @JvmName("ataipsrwjhceyetl")
    public suspend fun fqdnSubdomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnSubdomain = mapped
    }

    /**
     * @param value Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("bfmmfrxunusdmyev")
    public suspend fun httpProxyConfig(`value`: ManagedClusterHTTPProxyConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument Configurations for provisioning the cluster with HTTP proxy servers.
     */
    @JvmName("ejvkgcollngfbevo")
    public suspend
    fun httpProxyConfig(argument: suspend ManagedClusterHTTPProxyConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterHTTPProxyConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value The identity of the managed cluster, if configured.
     */
    @JvmName("wfhfnmycelsgnhxs")
    public suspend fun identity(`value`: ManagedClusterIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the managed cluster, if configured.
     */
    @JvmName("oywhnqaadspifimj")
    public suspend fun identity(argument: suspend ManagedClusterIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Identities associated with the cluster.
     */
    @JvmName("hytrfprgjowdidjy")
    public suspend fun identityProfile(`value`: Map<String, UserAssignedIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProfile = mapped
    }

    /**
     * @param argument Identities associated with the cluster.
     */
    @JvmName("yayomchccavhsjqy")
    public suspend fun identityProfile(
        vararg
        argument: Pair<String, suspend UserAssignedIdentityArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserAssignedIdentityArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.identityProfile = mapped
    }

    /**
     * @param values Identities associated with the cluster.
     */
    @JvmName("sfwnbwrxvsiudfhv")
    public fun identityProfile(vararg values: Pair<String, UserAssignedIdentityArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProfile = mapped
    }

    /**
     * @param value Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. When you upgrade a supported AKS cluster, Kubernetes minor versions cannot be skipped. All upgrades must be performed sequentially by major version number. For example, upgrades between 1.14.x -> 1.15.x or 1.15.x -> 1.16.x are allowed, however 1.14.x -> 1.16.x is not allowed. See [upgrading an AKS cluster](https://docs.microsoft.com/azure/aks/upgrade-cluster) for more details.
     */
    @JvmName("wvudppeigwvfshyh")
    public suspend fun kubernetesVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value The profile for Linux VMs in the Managed Cluster.
     */
    @JvmName("umdcboboyliqhpqm")
    public suspend fun linuxProfile(`value`: ContainerServiceLinuxProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxProfile = mapped
    }

    /**
     * @param argument The profile for Linux VMs in the Managed Cluster.
     */
    @JvmName("pwixbwvhusxxfixg")
    public suspend
    fun linuxProfile(argument: suspend ContainerServiceLinuxProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServiceLinuxProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxProfile = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tyauvpevqgdkcxom")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The network configuration profile.
     */
    @JvmName("uaanbmyhkpxdmuqg")
    public suspend fun networkProfile(`value`: ContainerServiceNetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument The network configuration profile.
     */
    @JvmName("mhpreiicgatkomit")
    public suspend
    fun networkProfile(argument: suspend ContainerServiceNetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServiceNetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The name of the resource group containing agent pool nodes.
     */
    @JvmName("ibuproxyfiokvcup")
    public suspend fun nodeResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeResourceGroup = mapped
    }

    /**
     * @param value The OIDC issuer profile of the Managed Cluster.
     */
    @JvmName("mscdcnnsuspwmpmc")
    public suspend fun oidcIssuerProfile(`value`: ManagedClusterOIDCIssuerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcIssuerProfile = mapped
    }

    /**
     * @param argument The OIDC issuer profile of the Managed Cluster.
     */
    @JvmName("gotchcklupwudili")
    public suspend
    fun oidcIssuerProfile(argument: suspend ManagedClusterOIDCIssuerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterOIDCIssuerProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oidcIssuerProfile = mapped
    }

    /**
     * @param value See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
     */
    @JvmName("yuhoohjfgxoarjpy")
    public suspend fun podIdentityProfile(`value`: ManagedClusterPodIdentityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podIdentityProfile = mapped
    }

    /**
     * @param argument See [use AAD pod identity](https://docs.microsoft.com/azure/aks/use-azure-ad-pod-identity) for more details on AAD pod identity integration.
     */
    @JvmName("pjvcfltyktcvxfgt")
    public suspend
    fun podIdentityProfile(argument: suspend ManagedClusterPodIdentityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterPodIdentityProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.podIdentityProfile = mapped
    }

    /**
     * @param value Private link resources associated with the cluster.
     */
    @JvmName("wxmiaetfxbqahwjj")
    public suspend fun privateLinkResources(`value`: List<PrivateLinkResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResources = mapped
    }

    /**
     * @param argument Private link resources associated with the cluster.
     */
    @JvmName("hawijargqdgdwduk")
    public suspend
    fun privateLinkResources(argument: List<suspend PrivateLinkResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkResources = mapped
    }

    /**
     * @param argument Private link resources associated with the cluster.
     */
    @JvmName("lsbayeugnhfflxkf")
    public suspend fun privateLinkResources(
        vararg
        argument: suspend PrivateLinkResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateLinkResourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkResources = mapped
    }

    /**
     * @param argument Private link resources associated with the cluster.
     */
    @JvmName("accvcihdfugwmdvl")
    public suspend
    fun privateLinkResources(argument: suspend PrivateLinkResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PrivateLinkResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.privateLinkResources = mapped
    }

    /**
     * @param values Private link resources associated with the cluster.
     */
    @JvmName("pvlbajtrotvtjjek")
    public suspend fun privateLinkResources(vararg values: PrivateLinkResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkResources = mapped
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("cibkhrsakadxkpdb")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("bbueejqglhmbidfh")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allow or deny public network access for AKS
     */
    @JvmName("jusrwubirqpvhsry")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("svnuuavhfjsxeieq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("vqkrmxeyhbgpvaep")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Security profile for the managed cluster.
     */
    @JvmName("bcheqjeggrjtnwgw")
    public suspend fun securityProfile(`value`: ManagedClusterSecurityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProfile = mapped
    }

    /**
     * @param argument Security profile for the managed cluster.
     */
    @JvmName("uafcfhojgrurduyr")
    public suspend
    fun securityProfile(argument: suspend ManagedClusterSecurityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterSecurityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityProfile = mapped
    }

    /**
     * @param value Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    @JvmName("gqrsfudpaqtrawwx")
    public suspend fun servicePrincipalProfile(`value`: ManagedClusterServicePrincipalProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalProfile = mapped
    }

    /**
     * @param argument Information about a service principal identity for the cluster to use for manipulating Azure APIs.
     */
    @JvmName("bifboctrvnrwjtxe")
    public suspend
    fun servicePrincipalProfile(argument: suspend ManagedClusterServicePrincipalProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterServicePrincipalProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalProfile = mapped
    }

    /**
     * @param value The managed cluster SKU.
     */
    @JvmName("xcqpvcoikqivppgb")
    public suspend fun sku(`value`: ManagedClusterSKUArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The managed cluster SKU.
     */
    @JvmName("htlgeetcyytvjrxy")
    public suspend fun sku(argument: suspend ManagedClusterSKUArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterSKUArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Storage profile for the managed cluster.
     */
    @JvmName("wervoykacyxqkinc")
    public suspend fun storageProfile(`value`: ManagedClusterStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage profile for the managed cluster.
     */
    @JvmName("uikrrbuxculdpgwm")
    public suspend
    fun storageProfile(argument: suspend ManagedClusterStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterStorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("xhetfcijyldnidiu")
    public suspend fun supportPlan(`value`: Either<String, KubernetesSupportPlan>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportPlan = mapped
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("cfvdqjlddhboxsrm")
    public fun supportPlan(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KubernetesSupportPlan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportPlan = mapped
    }

    /**
     * @param value The support plan for the Managed Cluster. If unspecified, the default is 'KubernetesOfficial'.
     */
    @JvmName("eciwyjagwjkiyeku")
    public fun supportPlan(`value`: KubernetesSupportPlan) {
        val toBeMapped = Either.ofRight<String, KubernetesSupportPlan>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportPlan = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xxnwdkurbwlkrmad")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nedkcsroaymmxrly")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The profile for Windows VMs in the Managed Cluster.
     */
    @JvmName("fayhrlwopqrdopij")
    public suspend fun windowsProfile(`value`: ManagedClusterWindowsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsProfile = mapped
    }

    /**
     * @param argument The profile for Windows VMs in the Managed Cluster.
     */
    @JvmName("dfejqcydcwjxfmmm")
    public suspend
    fun windowsProfile(argument: suspend ManagedClusterWindowsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterWindowsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsProfile = mapped
    }

    /**
     * @param value Workload Auto-scaler profile for the managed cluster.
     */
    @JvmName("evqilocjtjpgiqsi")
    public suspend
    fun workloadAutoScalerProfile(`value`: ManagedClusterWorkloadAutoScalerProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadAutoScalerProfile = mapped
    }

    /**
     * @param argument Workload Auto-scaler profile for the managed cluster.
     */
    @JvmName("oaopyjdwjjbqrmrr")
    public suspend
    fun workloadAutoScalerProfile(argument: suspend ManagedClusterWorkloadAutoScalerProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedClusterWorkloadAutoScalerProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workloadAutoScalerProfile = mapped
    }

    internal fun build(): ManagedClusterArgs = ManagedClusterArgs(
        aadProfile = aadProfile,
        addonProfiles = addonProfiles,
        agentPoolProfiles = agentPoolProfiles,
        apiServerAccessProfile = apiServerAccessProfile,
        autoScalerProfile = autoScalerProfile,
        autoUpgradeProfile = autoUpgradeProfile,
        azureMonitorProfile = azureMonitorProfile,
        disableLocalAccounts = disableLocalAccounts,
        diskEncryptionSetID = diskEncryptionSetID,
        dnsPrefix = dnsPrefix,
        enablePodSecurityPolicy = enablePodSecurityPolicy,
        enableRBAC = enableRBAC,
        extendedLocation = extendedLocation,
        fqdnSubdomain = fqdnSubdomain,
        httpProxyConfig = httpProxyConfig,
        identity = identity,
        identityProfile = identityProfile,
        kubernetesVersion = kubernetesVersion,
        linuxProfile = linuxProfile,
        location = location,
        networkProfile = networkProfile,
        nodeResourceGroup = nodeResourceGroup,
        oidcIssuerProfile = oidcIssuerProfile,
        podIdentityProfile = podIdentityProfile,
        privateLinkResources = privateLinkResources,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        securityProfile = securityProfile,
        servicePrincipalProfile = servicePrincipalProfile,
        sku = sku,
        storageProfile = storageProfile,
        supportPlan = supportPlan,
        tags = tags,
        windowsProfile = windowsProfile,
        workloadAutoScalerProfile = workloadAutoScalerProfile,
    )
}
