@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.ManagedClusterSnapshotArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.enums.SnapshotType
import com.pulumi.azurenative.containerservice.kotlin.inputs.CreationDataArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.CreationDataArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A managed cluster snapshot resource.
 * Azure REST API version: 2023-05-02-preview. Prior API version in Azure Native 1.x: 2022-02-02-preview.
 * Other available API versions: 2023-06-02-preview, 2023-07-02-preview, 2023-08-02-preview, 2023-09-02-preview, 2023-10-02-preview, 2023-11-02-preview, 2024-01-02-preview.
 * ## Example Usage
 * ### Create/Update Managed Cluster Snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterSnapshot = new AzureNative.ContainerService.ManagedClusterSnapshot("managedClusterSnapshot", new()
 *     {
 *         CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *         {
 *             SourceResourceId = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "snapshot1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *             { "key2", "val2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewManagedClusterSnapshot(ctx, "managedClusterSnapshot", &containerservice.ManagedClusterSnapshotArgs{
 * 			CreationData: &containerservice.CreationDataArgs{
 * 				SourceResourceId: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("snapshot1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 				"key2": pulumi.String("val2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.ManagedClusterSnapshot;
 * import com.pulumi.azurenative.containerservice.ManagedClusterSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterSnapshot = new ManagedClusterSnapshot("managedClusterSnapshot", ManagedClusterSnapshotArgs.builder()
 *             .creationData(Map.of("sourceResourceId", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.ContainerService/managedClusters/cluster1"))
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .resourceName("snapshot1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "val1"),
 *                 Map.entry("key2", "val2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:ManagedClusterSnapshot snapshot1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedclustersnapshots/{resourceName}
 * ```
 * @property creationData CreationData to be used to specify the source resource ID to create this snapshot.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the managed cluster resource.
 * @property snapshotType The type of a snapshot. The default is NodePool.
 * @property tags Resource tags.
 */
public data class ManagedClusterSnapshotArgs(
    public val creationData: Output<CreationDataArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val snapshotType: Output<Either<String, SnapshotType>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.ManagedClusterSnapshotArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.ManagedClusterSnapshotArgs =
        com.pulumi.azurenative.containerservice.ManagedClusterSnapshotArgs.builder()
            .creationData(creationData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .snapshotType(
                snapshotType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterSnapshotArgs].
 */
@PulumiTagMarker
public class ManagedClusterSnapshotArgsBuilder internal constructor() {
    private var creationData: Output<CreationDataArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var snapshotType: Output<Either<String, SnapshotType>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value CreationData to be used to specify the source resource ID to create this snapshot.
     */
    @JvmName("bmjhgiuujnhyyppd")
    public suspend fun creationData(`value`: Output<CreationDataArgs>) {
        this.creationData = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eyqyeukgimxgtorb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("itnrvkwrmpteivdf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("hoxhbqyqduksetlb")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("fwfxmskkescjqdye")
    public suspend fun snapshotType(`value`: Output<Either<String, SnapshotType>>) {
        this.snapshotType = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xnclgntkcwwtnhqu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value CreationData to be used to specify the source resource ID to create this snapshot.
     */
    @JvmName("yohaeqgjxkvtubon")
    public suspend fun creationData(`value`: CreationDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationData = mapped
    }

    /**
     * @param argument CreationData to be used to specify the source resource ID to create this snapshot.
     */
    @JvmName("gujuboqlqlclpucj")
    public suspend fun creationData(argument: suspend CreationDataArgsBuilder.() -> Unit) {
        val toBeMapped = CreationDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creationData = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("owbkxnmescavydrd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qvdiniauamjgyfhn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the managed cluster resource.
     */
    @JvmName("oyjjrcnfvrcfnawe")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("hyyabiqymjnpypwe")
    public suspend fun snapshotType(`value`: Either<String, SnapshotType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotType = mapped
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("ijfvibbtxxxuigty")
    public fun snapshotType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SnapshotType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotType = mapped
    }

    /**
     * @param value The type of a snapshot. The default is NodePool.
     */
    @JvmName("knqvrtinbxamcarx")
    public fun snapshotType(`value`: SnapshotType) {
        val toBeMapped = Either.ofRight<String, SnapshotType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotType = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qfyryrkpbppwouef")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hamtucvnywgpqeqc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedClusterSnapshotArgs = ManagedClusterSnapshotArgs(
        creationData = creationData,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        snapshotType = snapshotType,
        tags = tags,
    )
}
