@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterAgentPoolProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterAuthProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterMasterPoolProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterMonitorProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftRouterProfileResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.PurchasePlanResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.containerservice.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterAgentPoolProfileResponse.Companion.toKotlin as openShiftManagedClusterAgentPoolProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterAuthProfileResponse.Companion.toKotlin as openShiftManagedClusterAuthProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterMasterPoolProfileResponse.Companion.toKotlin as openShiftManagedClusterMasterPoolProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftManagedClusterMonitorProfileResponse.Companion.toKotlin as openShiftManagedClusterMonitorProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.OpenShiftRouterProfileResponse.Companion.toKotlin as openShiftRouterProfileResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.PurchasePlanResponse.Companion.toKotlin as purchasePlanResponseToKotlin

/**
 * Builder for [OpenShiftManagedCluster].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenShiftManagedClusterArgs = OpenShiftManagedClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenShiftManagedClusterArgsBuilder.() -> Unit) {
        val builder = OpenShiftManagedClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OpenShiftManagedCluster {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.OpenShiftManagedCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OpenShiftManagedCluster(builtJavaResource)
    }
}

/**
 * OpenShift Managed cluster.
 * Azure REST API version: 2019-10-27-preview. Prior API version in Azure Native 1.x: 2019-04-30.
 * Other available API versions: 2018-09-30-preview.
 * ## Example Usage
 * ### Create/Update OpenShift Managed Cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openShiftManagedCluster = new AzureNative.ContainerService.OpenShiftManagedCluster("openShiftManagedCluster", new()
 *     {
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 Name = "infra",
 *                 OsType = "Linux",
 *                 Role = "infra",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 4,
 *                 Name = "compute",
 *                 OsType = "Linux",
 *                 Role = "compute",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *         },
 *         AuthProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAuthProfileArgs
 *         {
 *             IdentityProviders = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterIdentityProviderArgs
 *                 {
 *                     Name = "Azure AD",
 *                     Provider =
 *                     {
 *                         { "clientId", "clientId" },
 *                         { "customerAdminGroupId", "customerAdminGroupId" },
 *                         { "kind", "AADIdentityProvider" },
 *                         { "secret", "secret" },
 *                         { "tenantId", "tenantId" },
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         MasterPoolProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMasterPoolProfileArgs
 *         {
 *             ApiProperties = new AzureNative.ContainerService.Inputs.OpenShiftAPIPropertiesArgs
 *             {
 *                 PrivateApiServer = false,
 *             },
 *             Count = 3,
 *             SubnetCidr = "10.0.0.0/24",
 *             VmSize = "Standard_D4s_v3",
 *         },
 *         MonitorProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMonitorProfileArgs
 *         {
 *             Enabled = true,
 *             WorkspaceResourceID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1",
 *         },
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.NetworkProfileArgs
 *         {
 *             VnetCidr = "10.0.0.0/8",
 *         },
 *         OpenShiftVersion = "v3.11",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         RouterProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftRouterProfileArgs
 *             {
 *                 Name = "default",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewOpenShiftManagedCluster(ctx, "openShiftManagedCluster", &containerservice.OpenShiftManagedClusterArgs{
 * 			AgentPoolProfiles: []containerservice.OpenShiftManagedClusterAgentPoolProfileArgs{
 * 				{
 * 					Count:      pulumi.Int(3),
 * 					Name:       pulumi.String("infra"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("infra"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 				{
 * 					Count:      pulumi.Int(4),
 * 					Name:       pulumi.String("compute"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("compute"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 			},
 * 			AuthProfile: containerservice.OpenShiftManagedClusterAuthProfileResponse{
 * 				IdentityProviders: []containerservice.OpenShiftManagedClusterIdentityProviderArgs{
 * 					{
 * 						Name: pulumi.String("Azure AD"),
 * 						Provider: {
 * 							ClientId:             pulumi.String("clientId"),
 * 							CustomerAdminGroupId: pulumi.String("customerAdminGroupId"),
 * 							Kind:                 pulumi.String("AADIdentityProvider"),
 * 							Secret:               pulumi.String("secret"),
 * 							TenantId:             pulumi.String("tenantId"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			MasterPoolProfile: containerservice.OpenShiftManagedClusterMasterPoolProfileResponse{
 * 				ApiProperties: &containerservice.OpenShiftAPIPropertiesArgs{
 * 					PrivateApiServer: pulumi.Bool(false),
 * 				},
 * 				Count:      pulumi.Int(3),
 * 				SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 				VmSize:     pulumi.String("Standard_D4s_v3"),
 * 			},
 * 			MonitorProfile: &containerservice.OpenShiftManagedClusterMonitorProfileArgs{
 * 				Enabled:             pulumi.Bool(true),
 * 				WorkspaceResourceID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1"),
 * 			},
 * 			NetworkProfile: &containerservice.NetworkProfileArgs{
 * 				VnetCidr: pulumi.String("10.0.0.0/8"),
 * 			},
 * 			OpenShiftVersion:  pulumi.String("v3.11"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			RouterProfiles: []containerservice.OpenShiftRouterProfileArgs{
 * 				{
 * 					Name: pulumi.String("default"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedCluster;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openShiftManagedCluster = new OpenShiftManagedCluster("openShiftManagedCluster", OpenShiftManagedClusterArgs.builder()
 *             .agentPoolProfiles(
 *                 Map.ofEntries(
 *                     Map.entry("count", 3),
 *                     Map.entry("name", "infra"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "infra"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("count", 4),
 *                     Map.entry("name", "compute"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "compute"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ))
 *             .authProfile(Map.of("identityProviders", Map.ofEntries(
 *                 Map.entry("name", "Azure AD"),
 *                 Map.entry("provider", Map.ofEntries(
 *                     Map.entry("clientId", "clientId"),
 *                     Map.entry("customerAdminGroupId", "customerAdminGroupId"),
 *                     Map.entry("kind", "AADIdentityProvider"),
 *                     Map.entry("secret", "secret"),
 *                     Map.entry("tenantId", "tenantId")
 *                 ))
 *             )))
 *             .location("location1")
 *             .masterPoolProfile(Map.ofEntries(
 *                 Map.entry("apiProperties", Map.of("privateApiServer", false)),
 *                 Map.entry("count", 3),
 *                 Map.entry("subnetCidr", "10.0.0.0/24"),
 *                 Map.entry("vmSize", "Standard_D4s_v3")
 *             ))
 *             .monitorProfile(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("workspaceResourceID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1")
 *             ))
 *             .networkProfile(Map.of("vnetCidr", "10.0.0.0/8"))
 *             .openShiftVersion("v3.11")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .routerProfiles(Map.of("name", "default"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create/Update Private OpenShift Managed Cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openShiftManagedCluster = new AzureNative.ContainerService.OpenShiftManagedCluster("openShiftManagedCluster", new()
 *     {
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 Name = "infra",
 *                 OsType = "Linux",
 *                 Role = "infra",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 4,
 *                 Name = "compute",
 *                 OsType = "Linux",
 *                 Role = "compute",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *         },
 *         AuthProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAuthProfileArgs
 *         {
 *             IdentityProviders = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterIdentityProviderArgs
 *                 {
 *                     Name = "Azure AD",
 *                     Provider =
 *                     {
 *                         { "clientId", "clientId" },
 *                         { "customerAdminGroupId", "customerAdminGroupId" },
 *                         { "kind", "AADIdentityProvider" },
 *                         { "secret", "secret" },
 *                         { "tenantId", "tenantId" },
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         MasterPoolProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMasterPoolProfileArgs
 *         {
 *             ApiProperties = new AzureNative.ContainerService.Inputs.OpenShiftAPIPropertiesArgs
 *             {
 *                 PrivateApiServer = true,
 *             },
 *             Count = 3,
 *             SubnetCidr = "10.0.0.0/24",
 *             VmSize = "Standard_D4s_v3",
 *         },
 *         MonitorProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMonitorProfileArgs
 *         {
 *             Enabled = true,
 *             WorkspaceResourceID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1",
 *         },
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.NetworkProfileArgs
 *         {
 *             ManagementSubnetCidr = "10.0.1.0/24",
 *             VnetCidr = "10.0.0.0/8",
 *         },
 *         OpenShiftVersion = "v3.11",
 *         RefreshCluster = true,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "privateclustername1",
 *         RouterProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftRouterProfileArgs
 *             {
 *                 Name = "default",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewOpenShiftManagedCluster(ctx, "openShiftManagedCluster", &containerservice.OpenShiftManagedClusterArgs{
 * 			AgentPoolProfiles: []containerservice.OpenShiftManagedClusterAgentPoolProfileArgs{
 * 				{
 * 					Count:      pulumi.Int(3),
 * 					Name:       pulumi.String("infra"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("infra"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 				{
 * 					Count:      pulumi.Int(4),
 * 					Name:       pulumi.String("compute"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("compute"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 			},
 * 			AuthProfile: containerservice.OpenShiftManagedClusterAuthProfileResponse{
 * 				IdentityProviders: []containerservice.OpenShiftManagedClusterIdentityProviderArgs{
 * 					{
 * 						Name: pulumi.String("Azure AD"),
 * 						Provider: {
 * 							ClientId:             pulumi.String("clientId"),
 * 							CustomerAdminGroupId: pulumi.String("customerAdminGroupId"),
 * 							Kind:                 pulumi.String("AADIdentityProvider"),
 * 							Secret:               pulumi.String("secret"),
 * 							TenantId:             pulumi.String("tenantId"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			MasterPoolProfile: containerservice.OpenShiftManagedClusterMasterPoolProfileResponse{
 * 				ApiProperties: &containerservice.OpenShiftAPIPropertiesArgs{
 * 					PrivateApiServer: pulumi.Bool(true),
 * 				},
 * 				Count:      pulumi.Int(3),
 * 				SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 				VmSize:     pulumi.String("Standard_D4s_v3"),
 * 			},
 * 			MonitorProfile: &containerservice.OpenShiftManagedClusterMonitorProfileArgs{
 * 				Enabled:             pulumi.Bool(true),
 * 				WorkspaceResourceID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1"),
 * 			},
 * 			NetworkProfile: &containerservice.NetworkProfileArgs{
 * 				ManagementSubnetCidr: pulumi.String("10.0.1.0/24"),
 * 				VnetCidr:             pulumi.String("10.0.0.0/8"),
 * 			},
 * 			OpenShiftVersion:  pulumi.String("v3.11"),
 * 			RefreshCluster:    pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("privateclustername1"),
 * 			RouterProfiles: []containerservice.OpenShiftRouterProfileArgs{
 * 				{
 * 					Name: pulumi.String("default"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedCluster;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openShiftManagedCluster = new OpenShiftManagedCluster("openShiftManagedCluster", OpenShiftManagedClusterArgs.builder()
 *             .agentPoolProfiles(
 *                 Map.ofEntries(
 *                     Map.entry("count", 3),
 *                     Map.entry("name", "infra"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "infra"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("count", 4),
 *                     Map.entry("name", "compute"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "compute"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ))
 *             .authProfile(Map.of("identityProviders", Map.ofEntries(
 *                 Map.entry("name", "Azure AD"),
 *                 Map.entry("provider", Map.ofEntries(
 *                     Map.entry("clientId", "clientId"),
 *                     Map.entry("customerAdminGroupId", "customerAdminGroupId"),
 *                     Map.entry("kind", "AADIdentityProvider"),
 *                     Map.entry("secret", "secret"),
 *                     Map.entry("tenantId", "tenantId")
 *                 ))
 *             )))
 *             .location("location1")
 *             .masterPoolProfile(Map.ofEntries(
 *                 Map.entry("apiProperties", Map.of("privateApiServer", true)),
 *                 Map.entry("count", 3),
 *                 Map.entry("subnetCidr", "10.0.0.0/24"),
 *                 Map.entry("vmSize", "Standard_D4s_v3")
 *             ))
 *             .monitorProfile(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("workspaceResourceID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1")
 *             ))
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("managementSubnetCidr", "10.0.1.0/24"),
 *                 Map.entry("vnetCidr", "10.0.0.0/8")
 *             ))
 *             .openShiftVersion("v3.11")
 *             .refreshCluster(true)
 *             .resourceGroupName("rg1")
 *             .resourceName("privateclustername1")
 *             .routerProfiles(Map.of("name", "default"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:OpenShiftManagedCluster privateclustername1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}
 * ```
 */
public class OpenShiftManagedCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.OpenShiftManagedCluster,
) : KotlinCustomResource(javaResource, OpenShiftManagedClusterMapper) {
    /**
     * Configuration of OpenShift cluster VMs.
     */
    public val agentPoolProfiles: Output<List<OpenShiftManagedClusterAgentPoolProfileResponse>>?
        get() = javaResource.agentPoolProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        openShiftManagedClusterAgentPoolProfileResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configures OpenShift authentication.
     */
    public val authProfile: Output<OpenShiftManagedClusterAuthProfileResponse>?
        get() = javaResource.authProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    openShiftManagedClusterAuthProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Version of OpenShift specified when creating the cluster.
     */
    public val clusterVersion: Output<String>
        get() = javaResource.clusterVersion().applyValue({ args0 -> args0 })

    /**
     * Service generated FQDN for OpenShift API server loadbalancer internal hostname.
     */
    public val fqdn: Output<String>
        get() = javaResource.fqdn().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Configuration for OpenShift master VMs.
     */
    public val masterPoolProfile: Output<OpenShiftManagedClusterMasterPoolProfileResponse>?
        get() = javaResource.masterPoolProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    openShiftManagedClusterMasterPoolProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Configures Log Analytics integration.
     */
    public val monitorProfile: Output<OpenShiftManagedClusterMonitorProfileResponse>?
        get() = javaResource.monitorProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    openShiftManagedClusterMonitorProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration for OpenShift networking.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Version of OpenShift specified when creating the cluster.
     */
    public val openShiftVersion: Output<String>
        get() = javaResource.openShiftVersion().applyValue({ args0 -> args0 })

    /**
     * Define the resource plan as required by ARM for billing purposes
     */
    public val plan: Output<PurchasePlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    purchasePlanResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The current deployment or provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Service generated FQDN or private IP for OpenShift API server.
     */
    public val publicHostname: Output<String>
        get() = javaResource.publicHostname().applyValue({ args0 -> args0 })

    /**
     * Allows node rotation
     */
    public val refreshCluster: Output<Boolean>?
        get() = javaResource.refreshCluster().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration for OpenShift router(s).
     */
    public val routerProfiles: Output<List<OpenShiftRouterProfileResponse>>?
        get() = javaResource.routerProfiles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        openShiftRouterProfileResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OpenShiftManagedClusterMapper : ResourceMapper<OpenShiftManagedCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.OpenShiftManagedCluster::class == javaResource::class

    override fun map(javaResource: Resource): OpenShiftManagedCluster =
        OpenShiftManagedCluster(
            javaResource as
                com.pulumi.azurenative.containerservice.OpenShiftManagedCluster,
        )
}

/**
 * @see [OpenShiftManagedCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenShiftManagedCluster].
 */
public suspend fun openShiftManagedCluster(
    name: String,
    block: suspend OpenShiftManagedClusterResourceBuilder.() -> Unit,
): OpenShiftManagedCluster {
    val builder = OpenShiftManagedClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenShiftManagedCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openShiftManagedCluster(name: String): OpenShiftManagedCluster {
    val builder = OpenShiftManagedClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
