@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs.builder
import com.pulumi.azurenative.containerservice.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterAgentPoolProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterAgentPoolProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterAuthProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterAuthProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterMasterPoolProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterMasterPoolProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterMonitorProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftManagedClusterMonitorProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftRouterProfileArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.OpenShiftRouterProfileArgsBuilder
import com.pulumi.azurenative.containerservice.kotlin.inputs.PurchasePlanArgs
import com.pulumi.azurenative.containerservice.kotlin.inputs.PurchasePlanArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * OpenShift Managed cluster.
 * Azure REST API version: 2019-10-27-preview. Prior API version in Azure Native 1.x: 2019-04-30.
 * Other available API versions: 2018-09-30-preview.
 * ## Example Usage
 * ### Create/Update OpenShift Managed Cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openShiftManagedCluster = new AzureNative.ContainerService.OpenShiftManagedCluster("openShiftManagedCluster", new()
 *     {
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 Name = "infra",
 *                 OsType = "Linux",
 *                 Role = "infra",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 4,
 *                 Name = "compute",
 *                 OsType = "Linux",
 *                 Role = "compute",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *         },
 *         AuthProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAuthProfileArgs
 *         {
 *             IdentityProviders = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterIdentityProviderArgs
 *                 {
 *                     Name = "Azure AD",
 *                     Provider =
 *                     {
 *                         { "clientId", "clientId" },
 *                         { "customerAdminGroupId", "customerAdminGroupId" },
 *                         { "kind", "AADIdentityProvider" },
 *                         { "secret", "secret" },
 *                         { "tenantId", "tenantId" },
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         MasterPoolProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMasterPoolProfileArgs
 *         {
 *             ApiProperties = new AzureNative.ContainerService.Inputs.OpenShiftAPIPropertiesArgs
 *             {
 *                 PrivateApiServer = false,
 *             },
 *             Count = 3,
 *             SubnetCidr = "10.0.0.0/24",
 *             VmSize = "Standard_D4s_v3",
 *         },
 *         MonitorProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMonitorProfileArgs
 *         {
 *             Enabled = true,
 *             WorkspaceResourceID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1",
 *         },
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.NetworkProfileArgs
 *         {
 *             VnetCidr = "10.0.0.0/8",
 *         },
 *         OpenShiftVersion = "v3.11",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         RouterProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftRouterProfileArgs
 *             {
 *                 Name = "default",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewOpenShiftManagedCluster(ctx, "openShiftManagedCluster", &containerservice.OpenShiftManagedClusterArgs{
 * 			AgentPoolProfiles: []containerservice.OpenShiftManagedClusterAgentPoolProfileArgs{
 * 				{
 * 					Count:      pulumi.Int(3),
 * 					Name:       pulumi.String("infra"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("infra"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 				{
 * 					Count:      pulumi.Int(4),
 * 					Name:       pulumi.String("compute"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("compute"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 			},
 * 			AuthProfile: containerservice.OpenShiftManagedClusterAuthProfileResponse{
 * 				IdentityProviders: []containerservice.OpenShiftManagedClusterIdentityProviderArgs{
 * 					{
 * 						Name: pulumi.String("Azure AD"),
 * 						Provider: {
 * 							ClientId:             pulumi.String("clientId"),
 * 							CustomerAdminGroupId: pulumi.String("customerAdminGroupId"),
 * 							Kind:                 pulumi.String("AADIdentityProvider"),
 * 							Secret:               pulumi.String("secret"),
 * 							TenantId:             pulumi.String("tenantId"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			MasterPoolProfile: containerservice.OpenShiftManagedClusterMasterPoolProfileResponse{
 * 				ApiProperties: &containerservice.OpenShiftAPIPropertiesArgs{
 * 					PrivateApiServer: pulumi.Bool(false),
 * 				},
 * 				Count:      pulumi.Int(3),
 * 				SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 				VmSize:     pulumi.String("Standard_D4s_v3"),
 * 			},
 * 			MonitorProfile: &containerservice.OpenShiftManagedClusterMonitorProfileArgs{
 * 				Enabled:             pulumi.Bool(true),
 * 				WorkspaceResourceID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1"),
 * 			},
 * 			NetworkProfile: &containerservice.NetworkProfileArgs{
 * 				VnetCidr: pulumi.String("10.0.0.0/8"),
 * 			},
 * 			OpenShiftVersion:  pulumi.String("v3.11"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 			RouterProfiles: []containerservice.OpenShiftRouterProfileArgs{
 * 				{
 * 					Name: pulumi.String("default"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedCluster;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openShiftManagedCluster = new OpenShiftManagedCluster("openShiftManagedCluster", OpenShiftManagedClusterArgs.builder()
 *             .agentPoolProfiles(
 *                 Map.ofEntries(
 *                     Map.entry("count", 3),
 *                     Map.entry("name", "infra"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "infra"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("count", 4),
 *                     Map.entry("name", "compute"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "compute"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ))
 *             .authProfile(Map.of("identityProviders", Map.ofEntries(
 *                 Map.entry("name", "Azure AD"),
 *                 Map.entry("provider", Map.ofEntries(
 *                     Map.entry("clientId", "clientId"),
 *                     Map.entry("customerAdminGroupId", "customerAdminGroupId"),
 *                     Map.entry("kind", "AADIdentityProvider"),
 *                     Map.entry("secret", "secret"),
 *                     Map.entry("tenantId", "tenantId")
 *                 ))
 *             )))
 *             .location("location1")
 *             .masterPoolProfile(Map.ofEntries(
 *                 Map.entry("apiProperties", Map.of("privateApiServer", false)),
 *                 Map.entry("count", 3),
 *                 Map.entry("subnetCidr", "10.0.0.0/24"),
 *                 Map.entry("vmSize", "Standard_D4s_v3")
 *             ))
 *             .monitorProfile(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("workspaceResourceID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1")
 *             ))
 *             .networkProfile(Map.of("vnetCidr", "10.0.0.0/8"))
 *             .openShiftVersion("v3.11")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .routerProfiles(Map.of("name", "default"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create/Update Private OpenShift Managed Cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var openShiftManagedCluster = new AzureNative.ContainerService.OpenShiftManagedCluster("openShiftManagedCluster", new()
 *     {
 *         AgentPoolProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 3,
 *                 Name = "infra",
 *                 OsType = "Linux",
 *                 Role = "infra",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *             new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAgentPoolProfileArgs
 *             {
 *                 Count = 4,
 *                 Name = "compute",
 *                 OsType = "Linux",
 *                 Role = "compute",
 *                 SubnetCidr = "10.0.0.0/24",
 *                 VmSize = "Standard_D4s_v3",
 *             },
 *         },
 *         AuthProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterAuthProfileArgs
 *         {
 *             IdentityProviders = new[]
 *             {
 *                 new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterIdentityProviderArgs
 *                 {
 *                     Name = "Azure AD",
 *                     Provider =
 *                     {
 *                         { "clientId", "clientId" },
 *                         { "customerAdminGroupId", "customerAdminGroupId" },
 *                         { "kind", "AADIdentityProvider" },
 *                         { "secret", "secret" },
 *                         { "tenantId", "tenantId" },
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "location1",
 *         MasterPoolProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMasterPoolProfileArgs
 *         {
 *             ApiProperties = new AzureNative.ContainerService.Inputs.OpenShiftAPIPropertiesArgs
 *             {
 *                 PrivateApiServer = true,
 *             },
 *             Count = 3,
 *             SubnetCidr = "10.0.0.0/24",
 *             VmSize = "Standard_D4s_v3",
 *         },
 *         MonitorProfile = new AzureNative.ContainerService.Inputs.OpenShiftManagedClusterMonitorProfileArgs
 *         {
 *             Enabled = true,
 *             WorkspaceResourceID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1",
 *         },
 *         NetworkProfile = new AzureNative.ContainerService.Inputs.NetworkProfileArgs
 *         {
 *             ManagementSubnetCidr = "10.0.1.0/24",
 *             VnetCidr = "10.0.0.0/8",
 *         },
 *         OpenShiftVersion = "v3.11",
 *         RefreshCluster = true,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "privateclustername1",
 *         RouterProfiles = new[]
 *         {
 *             new AzureNative.ContainerService.Inputs.OpenShiftRouterProfileArgs
 *             {
 *                 Name = "default",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "archv2", "" },
 *             { "tier", "production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewOpenShiftManagedCluster(ctx, "openShiftManagedCluster", &containerservice.OpenShiftManagedClusterArgs{
 * 			AgentPoolProfiles: []containerservice.OpenShiftManagedClusterAgentPoolProfileArgs{
 * 				{
 * 					Count:      pulumi.Int(3),
 * 					Name:       pulumi.String("infra"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("infra"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 				{
 * 					Count:      pulumi.Int(4),
 * 					Name:       pulumi.String("compute"),
 * 					OsType:     pulumi.String("Linux"),
 * 					Role:       pulumi.String("compute"),
 * 					SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 					VmSize:     pulumi.String("Standard_D4s_v3"),
 * 				},
 * 			},
 * 			AuthProfile: containerservice.OpenShiftManagedClusterAuthProfileResponse{
 * 				IdentityProviders: []containerservice.OpenShiftManagedClusterIdentityProviderArgs{
 * 					{
 * 						Name: pulumi.String("Azure AD"),
 * 						Provider: {
 * 							ClientId:             pulumi.String("clientId"),
 * 							CustomerAdminGroupId: pulumi.String("customerAdminGroupId"),
 * 							Kind:                 pulumi.String("AADIdentityProvider"),
 * 							Secret:               pulumi.String("secret"),
 * 							TenantId:             pulumi.String("tenantId"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("location1"),
 * 			MasterPoolProfile: containerservice.OpenShiftManagedClusterMasterPoolProfileResponse{
 * 				ApiProperties: &containerservice.OpenShiftAPIPropertiesArgs{
 * 					PrivateApiServer: pulumi.Bool(true),
 * 				},
 * 				Count:      pulumi.Int(3),
 * 				SubnetCidr: pulumi.String("10.0.0.0/24"),
 * 				VmSize:     pulumi.String("Standard_D4s_v3"),
 * 			},
 * 			MonitorProfile: &containerservice.OpenShiftManagedClusterMonitorProfileArgs{
 * 				Enabled:             pulumi.Bool(true),
 * 				WorkspaceResourceID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1"),
 * 			},
 * 			NetworkProfile: &containerservice.NetworkProfileArgs{
 * 				ManagementSubnetCidr: pulumi.String("10.0.1.0/24"),
 * 				VnetCidr:             pulumi.String("10.0.0.0/8"),
 * 			},
 * 			OpenShiftVersion:  pulumi.String("v3.11"),
 * 			RefreshCluster:    pulumi.Bool(true),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("privateclustername1"),
 * 			RouterProfiles: []containerservice.OpenShiftRouterProfileArgs{
 * 				{
 * 					Name: pulumi.String("default"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"archv2": pulumi.String(""),
 * 				"tier":   pulumi.String("production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedCluster;
 * import com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var openShiftManagedCluster = new OpenShiftManagedCluster("openShiftManagedCluster", OpenShiftManagedClusterArgs.builder()
 *             .agentPoolProfiles(
 *                 Map.ofEntries(
 *                     Map.entry("count", 3),
 *                     Map.entry("name", "infra"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "infra"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("count", 4),
 *                     Map.entry("name", "compute"),
 *                     Map.entry("osType", "Linux"),
 *                     Map.entry("role", "compute"),
 *                     Map.entry("subnetCidr", "10.0.0.0/24"),
 *                     Map.entry("vmSize", "Standard_D4s_v3")
 *                 ))
 *             .authProfile(Map.of("identityProviders", Map.ofEntries(
 *                 Map.entry("name", "Azure AD"),
 *                 Map.entry("provider", Map.ofEntries(
 *                     Map.entry("clientId", "clientId"),
 *                     Map.entry("customerAdminGroupId", "customerAdminGroupId"),
 *                     Map.entry("kind", "AADIdentityProvider"),
 *                     Map.entry("secret", "secret"),
 *                     Map.entry("tenantId", "tenantId")
 *                 ))
 *             )))
 *             .location("location1")
 *             .masterPoolProfile(Map.ofEntries(
 *                 Map.entry("apiProperties", Map.of("privateApiServer", true)),
 *                 Map.entry("count", 3),
 *                 Map.entry("subnetCidr", "10.0.0.0/24"),
 *                 Map.entry("vmSize", "Standard_D4s_v3")
 *             ))
 *             .monitorProfile(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("workspaceResourceID", "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.OperationalInsights/workspaces/workspacename1")
 *             ))
 *             .networkProfile(Map.ofEntries(
 *                 Map.entry("managementSubnetCidr", "10.0.1.0/24"),
 *                 Map.entry("vnetCidr", "10.0.0.0/8")
 *             ))
 *             .openShiftVersion("v3.11")
 *             .refreshCluster(true)
 *             .resourceGroupName("rg1")
 *             .resourceName("privateclustername1")
 *             .routerProfiles(Map.of("name", "default"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("archv2", ""),
 *                 Map.entry("tier", "production")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:OpenShiftManagedCluster privateclustername1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/openShiftManagedClusters/{resourceName}
 * ```
 * @property agentPoolProfiles Configuration of OpenShift cluster VMs.
 * @property authProfile Configures OpenShift authentication.
 * @property location Resource location
 * @property masterPoolProfile Configuration for OpenShift master VMs.
 * @property monitorProfile Configures Log Analytics integration.
 * @property networkProfile Configuration for OpenShift networking.
 * @property openShiftVersion Version of OpenShift specified when creating the cluster.
 * @property plan Define the resource plan as required by ARM for billing purposes
 * @property refreshCluster Allows node rotation
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the OpenShift managed cluster resource.
 * @property routerProfiles Configuration for OpenShift router(s).
 * @property tags Resource tags
 */
public data class OpenShiftManagedClusterArgs(
    public val agentPoolProfiles: Output<List<OpenShiftManagedClusterAgentPoolProfileArgs>>? = null,
    public val authProfile: Output<OpenShiftManagedClusterAuthProfileArgs>? = null,
    public val location: Output<String>? = null,
    public val masterPoolProfile: Output<OpenShiftManagedClusterMasterPoolProfileArgs>? = null,
    public val monitorProfile: Output<OpenShiftManagedClusterMonitorProfileArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val openShiftVersion: Output<String>? = null,
    public val plan: Output<PurchasePlanArgs>? = null,
    public val refreshCluster: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val routerProfiles: Output<List<OpenShiftRouterProfileArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs =
        com.pulumi.azurenative.containerservice.OpenShiftManagedClusterArgs.builder()
            .agentPoolProfiles(
                agentPoolProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .authProfile(authProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .masterPoolProfile(masterPoolProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitorProfile(monitorProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .openShiftVersion(openShiftVersion?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .refreshCluster(refreshCluster?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .routerProfiles(
                routerProfiles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OpenShiftManagedClusterArgs].
 */
@PulumiTagMarker
public class OpenShiftManagedClusterArgsBuilder internal constructor() {
    private var agentPoolProfiles: Output<List<OpenShiftManagedClusterAgentPoolProfileArgs>>? = null

    private var authProfile: Output<OpenShiftManagedClusterAuthProfileArgs>? = null

    private var location: Output<String>? = null

    private var masterPoolProfile: Output<OpenShiftManagedClusterMasterPoolProfileArgs>? = null

    private var monitorProfile: Output<OpenShiftManagedClusterMonitorProfileArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var openShiftVersion: Output<String>? = null

    private var plan: Output<PurchasePlanArgs>? = null

    private var refreshCluster: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var routerProfiles: Output<List<OpenShiftRouterProfileArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration of OpenShift cluster VMs.
     */
    @JvmName("vuppnvjuwjxmbqlc")
    public suspend
    fun agentPoolProfiles(`value`: Output<List<OpenShiftManagedClusterAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = value
    }

    @JvmName("obajxbhhaiftoqet")
    public suspend fun agentPoolProfiles(
        vararg
        values: Output<OpenShiftManagedClusterAgentPoolProfileArgs>,
    ) {
        this.agentPoolProfiles = Output.all(values.asList())
    }

    /**
     * @param values Configuration of OpenShift cluster VMs.
     */
    @JvmName("kjwargeupdidloge")
    public suspend
    fun agentPoolProfiles(values: List<Output<OpenShiftManagedClusterAgentPoolProfileArgs>>) {
        this.agentPoolProfiles = Output.all(values)
    }

    /**
     * @param value Configures OpenShift authentication.
     */
    @JvmName("jjyouxxgihyhplgc")
    public suspend fun authProfile(`value`: Output<OpenShiftManagedClusterAuthProfileArgs>) {
        this.authProfile = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("bwtakexhvfmexwuj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Configuration for OpenShift master VMs.
     */
    @JvmName("cxnevggjylxtwceg")
    public suspend
    fun masterPoolProfile(`value`: Output<OpenShiftManagedClusterMasterPoolProfileArgs>) {
        this.masterPoolProfile = value
    }

    /**
     * @param value Configures Log Analytics integration.
     */
    @JvmName("etihjijfkfrpkwpo")
    public suspend fun monitorProfile(`value`: Output<OpenShiftManagedClusterMonitorProfileArgs>) {
        this.monitorProfile = value
    }

    /**
     * @param value Configuration for OpenShift networking.
     */
    @JvmName("mrphsueabjrgpmqq")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value Version of OpenShift specified when creating the cluster.
     */
    @JvmName("ijlrggwppjryfsha")
    public suspend fun openShiftVersion(`value`: Output<String>) {
        this.openShiftVersion = value
    }

    /**
     * @param value Define the resource plan as required by ARM for billing purposes
     */
    @JvmName("fonwaehtnxtqmlgr")
    public suspend fun plan(`value`: Output<PurchasePlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Allows node rotation
     */
    @JvmName("uasystduuklwksce")
    public suspend fun refreshCluster(`value`: Output<Boolean>) {
        this.refreshCluster = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lkanqbhsjmsptopu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the OpenShift managed cluster resource.
     */
    @JvmName("xtqdxolfuyiduujl")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Configuration for OpenShift router(s).
     */
    @JvmName("jpsuehnmlltegips")
    public suspend fun routerProfiles(`value`: Output<List<OpenShiftRouterProfileArgs>>) {
        this.routerProfiles = value
    }

    @JvmName("ocbtkosmtacwysgs")
    public suspend fun routerProfiles(vararg values: Output<OpenShiftRouterProfileArgs>) {
        this.routerProfiles = Output.all(values.asList())
    }

    /**
     * @param values Configuration for OpenShift router(s).
     */
    @JvmName("htjqoxofbgihfweh")
    public suspend fun routerProfiles(values: List<Output<OpenShiftRouterProfileArgs>>) {
        this.routerProfiles = Output.all(values)
    }

    /**
     * @param value Resource tags
     */
    @JvmName("rpkisceegictjynd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration of OpenShift cluster VMs.
     */
    @JvmName("hjdfntsakwjflitk")
    public suspend
    fun agentPoolProfiles(`value`: List<OpenShiftManagedClusterAgentPoolProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument Configuration of OpenShift cluster VMs.
     */
    @JvmName("hbucmpkycprxxscv")
    public suspend
    fun agentPoolProfiles(argument: List<suspend OpenShiftManagedClusterAgentPoolProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenShiftManagedClusterAgentPoolProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument Configuration of OpenShift cluster VMs.
     */
    @JvmName("yrevkbfatacqefib")
    public suspend fun agentPoolProfiles(
        vararg
        argument: suspend OpenShiftManagedClusterAgentPoolProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OpenShiftManagedClusterAgentPoolProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param argument Configuration of OpenShift cluster VMs.
     */
    @JvmName("ikiyoadafxvijaqx")
    public suspend
    fun agentPoolProfiles(argument: suspend OpenShiftManagedClusterAgentPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OpenShiftManagedClusterAgentPoolProfileArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.agentPoolProfiles = mapped
    }

    /**
     * @param values Configuration of OpenShift cluster VMs.
     */
    @JvmName("veliuoxjxcaebfvb")
    public suspend fun agentPoolProfiles(vararg values: OpenShiftManagedClusterAgentPoolProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentPoolProfiles = mapped
    }

    /**
     * @param value Configures OpenShift authentication.
     */
    @JvmName("wofskgcwxbomayrp")
    public suspend fun authProfile(`value`: OpenShiftManagedClusterAuthProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authProfile = mapped
    }

    /**
     * @param argument Configures OpenShift authentication.
     */
    @JvmName("xwfallnxlncglldt")
    public suspend
    fun authProfile(argument: suspend OpenShiftManagedClusterAuthProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OpenShiftManagedClusterAuthProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authProfile = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("aicbqfdielexeppg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Configuration for OpenShift master VMs.
     */
    @JvmName("ipkrcgpnccnuuybv")
    public suspend fun masterPoolProfile(`value`: OpenShiftManagedClusterMasterPoolProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterPoolProfile = mapped
    }

    /**
     * @param argument Configuration for OpenShift master VMs.
     */
    @JvmName("onawsfjpmifxmcnm")
    public suspend
    fun masterPoolProfile(argument: suspend OpenShiftManagedClusterMasterPoolProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OpenShiftManagedClusterMasterPoolProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.masterPoolProfile = mapped
    }

    /**
     * @param value Configures Log Analytics integration.
     */
    @JvmName("khyyqpulyfnmdxle")
    public suspend fun monitorProfile(`value`: OpenShiftManagedClusterMonitorProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorProfile = mapped
    }

    /**
     * @param argument Configures Log Analytics integration.
     */
    @JvmName("tqmvgqjfwnthwlnc")
    public suspend
    fun monitorProfile(argument: suspend OpenShiftManagedClusterMonitorProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OpenShiftManagedClusterMonitorProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.monitorProfile = mapped
    }

    /**
     * @param value Configuration for OpenShift networking.
     */
    @JvmName("txwebhcxdhfvlhmg")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Configuration for OpenShift networking.
     */
    @JvmName("vpidwglmljqyryul")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value Version of OpenShift specified when creating the cluster.
     */
    @JvmName("vkqqsnadytunjkon")
    public suspend fun openShiftVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openShiftVersion = mapped
    }

    /**
     * @param value Define the resource plan as required by ARM for billing purposes
     */
    @JvmName("dqtddqgacjesfxal")
    public suspend fun plan(`value`: PurchasePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Define the resource plan as required by ARM for billing purposes
     */
    @JvmName("nwrsqklknvcdqfxn")
    public suspend fun plan(argument: suspend PurchasePlanArgsBuilder.() -> Unit) {
        val toBeMapped = PurchasePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Allows node rotation
     */
    @JvmName("xcoljcytdcajijyo")
    public suspend fun refreshCluster(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshCluster = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ssytdyshebwwffah")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the OpenShift managed cluster resource.
     */
    @JvmName("aheswmmfqtqkoixp")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Configuration for OpenShift router(s).
     */
    @JvmName("cbfagyocbuiykwfa")
    public suspend fun routerProfiles(`value`: List<OpenShiftRouterProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routerProfiles = mapped
    }

    /**
     * @param argument Configuration for OpenShift router(s).
     */
    @JvmName("uqynvrfmmcwsbbtw")
    public suspend
    fun routerProfiles(argument: List<suspend OpenShiftRouterProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenShiftRouterProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routerProfiles = mapped
    }

    /**
     * @param argument Configuration for OpenShift router(s).
     */
    @JvmName("ehbeyvohwtuuitup")
    public suspend fun routerProfiles(
        vararg
        argument: suspend OpenShiftRouterProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            OpenShiftRouterProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routerProfiles = mapped
    }

    /**
     * @param argument Configuration for OpenShift router(s).
     */
    @JvmName("gyvmbrdmwdxqmpwc")
    public suspend
    fun routerProfiles(argument: suspend OpenShiftRouterProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OpenShiftRouterProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routerProfiles = mapped
    }

    /**
     * @param values Configuration for OpenShift router(s).
     */
    @JvmName("vtyabdlicaormblb")
    public suspend fun routerProfiles(vararg values: OpenShiftRouterProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routerProfiles = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("tgyhaioiweftvrku")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("piaskqgrveamxdxw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OpenShiftManagedClusterArgs = OpenShiftManagedClusterArgs(
        agentPoolProfiles = agentPoolProfiles,
        authProfile = authProfile,
        location = location,
        masterPoolProfile = masterPoolProfile,
        monitorProfile = monitorProfile,
        networkProfile = networkProfile,
        openShiftVersion = openShiftVersion,
        plan = plan,
        refreshCluster = refreshCluster,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        routerProfiles = routerProfiles,
        tags = tags,
    )
}
